function sistemas(entrada);
%SISTEMAS rene los ejemplos de los sistemas 2x2 contemplados en 
%cramer, egcpp y egsp.
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' SOLUCION DE SISTEMAS DE ECUACIONES LINEALES 2X2',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   %Propsito del tema
   indica = str2mat(' ',...
    '   Propsito del tema: ',...
    '',...
    '  Destacar cmo repercute el error de redondeo en la',...
    '  posible obtencin de soluciones incorrectas o poco',...
    '  satisfactorias an para sistemas de ecuaciones',...
    '  lineales 2x2.',...
    '  ',...
    '  ',...
    '  ','','','','',...
    '   Instrucciones: Oprima alguno de los botones de la derecha',...
    '  segn el mtodo de solucin que elija para resolver el',...
    '  sistema correspondiente (escrito arriba del botn).');
   
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.05 .2 .6 .6],...
             'BackgroundColor',[1 1 1]);
    
   %El campo del propsito e instrucciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',15,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.07 .22 .56 .56],...
                        'String',indica);
                   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del Taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
   
   %La consola de botones y menus de control
   axes('Units','normalized','Box','on','XTick',[],'YTick',[],'Visible','on',...
        'Position',[.67 .03 .3 .94],...
        'Color',[0 .8 0]);
     
   %El rtulo 'Ejemplos'
   uicontrol('Style','text','Units','normalized',...
             'Position',[.75 .91 .14 .04],...
             'BackgroundColor',[0 .8 0],...
             'ForegroundColor',[0 0 0],...
             'String','Ejemplos:');
        
   %El cuadro y botn del ejemplo 1       
   axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.68 .78 .28 .12]);
   acetato('','\fontsize{9}  0.373x + 0.296y = 0.521','','','\fontsize{9}  0.326x + 0.260y = 0.456');
   uicontrol('Style','pushbutton','Units','normalized',...
             'String','Regla de Cramer','Position',[.72 .78 .2 .04],...
             'Callback','cramer(''iniciar'');');
        
   %El cuadro y botn del ejemplo 2       
   axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.68 .64 .28 .12]);
   acetato('','\fontsize{8} 0.2161x +0.1441y = 0.1440','','','\fontsize{8} 1.2969x + 0.8648y = 0.8642');
   uicontrol('Style','pushbutton','Units','normalized',...
             'String','E G c P P','Position',[.72 .64 .2 .04],...
             'Callback','egcpp(''iniciar'');');
        
   %El cuadro y botn del ejemplo 3       
   axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.68 .5 .28 .12]);
   acetato('','\fontsize{9}     0.0001x + y = 1','','','\fontsize{9}                x + y = 2');
   uicontrol('Style','pushbutton','Units','normalized',...
             'String','E G s P','Position',[.72 .5 .2 .04],...
             'Callback','egsp(''iniciar'');');
      
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.72 .07 .2 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
  
end %if strcmp(entrada,...)