function s1_2alan(entrada);
%S1_2ALAN calcula el valor numrico de la serie 1 / 2^(n)
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' S E R I E   1/(2^n)',...
   'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','off');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .6]);
      
   acetato('','  Encontrar el valor de la serie geomtrica','','                                   \infty','\fontsize{35}           \Sigma 1/2^n','                                 n = 1');
   
 %Comentarios de inicio
 indica = str2mat('   Presione el botn ''Valor'' para calcular la suma de los trminos',...
     '  que contribuyen a la serie, dada la precisin elegida.',...
     ' ',...
     '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
     '  longitud de mantisa. Enseguida vuelva a utilizar el botn ''Valor''.');
   
 %El marco del cuadro de comentarios y explicaciones
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.03 .03 .74 .34],...
           'BackgroundColor',[0 .8 0]);
   
 %El rtulo COMENTARIOS Y EXPLICACIONES
 uicontrol('Style','text','Units','normalized',...
           'Position',[.05 .3 .7 .05],...
           'BackgroundColor',[0 .6 0],...
           'ForegroundColor',[1 1 1],...
           'String','COMENTARIOS Y EXPLICACIONES');
   
 %El campo editable de explicaciones
 NIPtexto = uicontrol('Style','text','Units','normalized',...
                      'HorizontalAlignment','left',...
                      'Max',10,...
                      'BackgroundColor',[1 1 1],...
                      'Position',[.05 .05 .7 .25],...
                      'Callback','s1_2alan(''eval'');',...
                      'String',indica);
   
 %Men 'VENTANA'
 vent = uimenu(figNumber,'Label','VENTANA');
 uimenu(vent,'Label','Imprimir','Callback','print');
 uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
 %Men 'REGRESAR'
 retorno = uimenu(figNumber,'Label','REGRESAR');
 uimenu(retorno,'Label','a men de S u m a s','Callback','sumas;');
 uimenu(retorno,'Label','a T e m a s','Callback','temas;');
 uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
 
 %La consola de botones y menus de control
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.78 .03 .2 .94],...
           'BackgroundColor',[0 .8 0]);
    
 %botn 'Valor de la serie'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .8 .16 .06],...
           'String','V a l o r',...
           'Callback','s1_2alan(''ejecuta'');',...
           'UserData','valor');
   
 %men 'precisin'
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.81 .7 .14 .05],...
           'BackgroundColor',[.6 .8 1]);
 uicontrol('Style','text','Units','normalized',...
           'Position',[.82 .71 .12 .03],...
           'BackgroundColor',[.6 .8 1],...
           'ForegroundColor',[0 0 0],...
           'String','Precisin');
 prec = uicontrol('Style','popupmenu','Units','normalized',...
                  'Position',[.81 .63 .14 .07],...
                  'String',str2mat(' t = 1',' t = 2',' t = 3',...
                  ' t = 4',' t = 5',' t = 6',...
                  ' t = 7',' t = 8',' t = 9',...
                  ' t = 10',' t = 11',' t = 12'),...
                  'Callback','s1_2alan(''ejecuta'');',...
                  'Value',7);
       
 %botn INFO
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .15 .16 .06],...
           'String','I n f o',...
           'Callback','s1_2alan(''info'');');
   
 %botn 'Salir'
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .07 .16 .06],...
           'String','S a l i r',...
           'Callback','close(gcf)');
   
 %Guardar el cuadro de explicaciones y el men 'precisin' 
 cambios = [NIPtexto prec];
 
 %Descubrir la ventana
 set(gcf,'Visible','on','UserData',cambios);
 
elseif strcmp(entrada,'ejecuta'),
   
 %Se traen los objetos grficos salvados con anterioridad   
 cambios = get(gcf,'UserData');
 NIPtexto = cambios(1);
 prec = cambios(2);
 accion = get(gco,'UserData');  
 t = get(prec,'Value');
  
 %Activacin del botn 'Valor'
 if strcmp(accion,'valor'),
    
    %Clculo de la serie. Suma de trminos en orden decreciente.
    sumaAnterior = guardar(0,t);
    uno = guardar(1,t);
    serie = guardar(1/2,t);
    k = 1;
     %Se suman los trminos que contribuyen a la serie
     while valornum(serie) ~= valornum(sumaAnterior)
       k = k+1;
       ka = guardar(2^k,t);
       termino = op_flot(uno,ka,'/');
       sumaAnterior = serie;
       serie = op_flot(serie,termino,'+'); 
     end
     %El k-simo trmino ya no contribuye a la suma
     k = k-1;
    
    %Clculo de la serie. Suma de trminos en orden creciente.
    serieCrec = guardar(0,t);
    for i = k:-1:1
       m = guardar(2^i,t);
       term = op_flot(uno,m,'/');
       serieCrec = op_flot(serieCrec,term,'+');
    end
    
    %Valor exacto de la serie. Suma de los k trminos
    s_n = 0;
    for j = 1:k
       t_n = 1/(2^j);
       s_n = s_n + t_n;
    end   
    acetato(' Suma en Orden DECRECIENTE:',[' El valor de la suma es ' notacion(serie)],['y contribuyen ' num2str(k) ' trminos.'],'',' Suma en Orden CRECIENTE:',['El valor de la suma es ' notacion(serieCrec) '.'],'',['La serie \Sigma 1/2^n , n = 1,2,... converge al valor ' num2str(round(s_n)) '.']);
    expl = str2mat( ...
       '   Se muestra en ambas formas de ordenacin el valor numrico de la serie',...
      ['  en notacin de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
       ' ',...
       '   Compare los valores numricos con el valor exacto.');
    set(NIPtexto,'String',expl);
       
 end %if strcmp(accion,...)  
 
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' S E R I E   1/(2^n)',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' Una serie geomtrica tiene la forma',...
      '                       \Sigma_{n=1}^{\infty} r^{n} ,     con  0 < r < 1.',...
      ' Matemticamente se demuestra que las series geomtricas',...
      'convergen al valor   r / (1 - r).',...
      ' ',...
      ' La serie geomtrica \Sigma_{n=1}^{\infty} 1/2^{n} = \Sigma_{n=1}^{\infty} (1/2)^{n} converge',...
      'al valor 1.',...
      ' ',...
      ' El valor numrico de esta serie es calculado sumando primero',...
      'sus trminos en orden decreciente (ordenados del mayor al menor',...
      'en valor absoluto) con lo que se encuentra el nmero mximo de',...
      'trminos que contribuyen a la suma, y luego se realiza el clculo',...
      'sumando los trminos en orden creciente (ordenados del menor',...
      'al mayor en valor absoluto).',...
      ' ',...
      ' Compare los resultados obtenidos por las dos formas de ordenacin.',...
      ' ',...
      ' ',...
      'Programa fuente: s1\_2alan.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
 
end %if strcmp(entrada,...)