function prod3num(entrada);
%PROD3NUM realiza la multiplicacin de 3 nmeros, asocindolos 
%de tres formas diferentes.
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' ASOCIATIVIDAD DEL PRODUCTO DE 3 NUMEROS',...
                      'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .59]);
      
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .34],...
             'BackgroundColor',[0 .8 0]);
   
   %Comentarios de inicio
      indica = str2mat('   Tenemos los nmeros reales a,b,c arriba mostrados.',...
               ' ',...
               '   Oprima alguno de los botones de la parte derecha superior y observe',...
               '  el resultado efectuando dicha asociacin.',...
               ' ',...
               '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
               '  longitud de mantisa. Enseguida vuelva a utilizar los botones.');
       
   %El campo para los comentarios y explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .25],...
                        'Callback','prod3num(''eval'');',...
                        'String',indica);
                   
   %Los rtulos 'a =','b =' y 'c ='
   uicontrol('Style','text','Units','normalized',...
             'Position',[.05 .31 .03 .05],'String','a =',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.29 .31 .03 .05],'String','b =',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.53 .31 .03 .05],'String','c =',...
             'Backgroundcolor',[0 .8 0]);
     
   %Los campos editables para que el usuario proporcione sus propios nmeros.
   %Inicialmente hay valores dados, los que constituyen el ejemplo.       
   dato1 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.08 .31 .18 .05],'String','1050',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');
   dato2 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.32 .31 .18 .05],'String','-25.55',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');        
   dato3 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.56 .31 .18 .05],'String','0.3333',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');
               
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del Taller  
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Operaciones bsicas','Callback','campo;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn '(axb)xc'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .86 .16 .06],...
             'String','(a x b) x c',...
             'Callback','prod3num(''ejecuta'');',...
             'UserData','ab_c');
   
   %Botn 'ax(bxc)'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .78 .16 .06],...
             'String','a x (b x c)',...
             'Callback','prod3num(''ejecuta'');',...
             'UserData','a_bc');
   
   %Botn '(axc)xb'
   uicontrol('Style','pushbutton','Units','normalized', ...
             'Position',[.8 .7 .16 .06],...
             'String','(a x c) x b',...
             'Callback','prod3num(''ejecuta'');',...
             'UserData','ac_b');
   
   %Men 'precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .6 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .61 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .53 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','prod3num(''ejecuta'');',...
                    'Value',5);
                 
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
                'Position',[.8 .15 .16 .06],...
                'Callback','prod3num(''info'');',...
                'String','I n f o');
              
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Se guardan los campos editables, el cuadro de explicaciones y el men 'precisin'
   %pues se requerirn en la siguiente parte del programa.
   cambios = [dato1 dato2 dato3 NIPtexto prec];
   set(gcf,'UserData',cambios);
   
elseif strcmp(entrada,'ejecuta'),
   
   %Se traen los objetos grficos salvados con anterioridad   
   cambios = get(gcf,'UserData');
   dato1 = cambios(1);
   dato2 = cambios(2);
   dato3 = cambios(3);
   NIPtexto = cambios(4);
   prec = cambios(5);
   asociar = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Obtencin de los nmeros introducidos por el usuario   
   if ~isempty(get(dato1,'String')) & ~isempty(get(dato2,'String')) & ~isempty(get(dato3,'String')),   
      a_real = eval(get(dato1,'String'));
      b_real = eval(get(dato2,'String'));
      c_real = eval(get(dato3,'String'));
       
      %El producto exacto de los nmeros proporcionados por el usuario
      prodExacto = a_real*b_real*c_real;
      
      %Se simula el guardar los nmeros del usuario en representacin
      %interna de una computadora que trabaja en base 10
      a = guardar(a_real,t);  
      b = guardar(b_real,t);  
      c = guardar(c_real,t);  
      
      %Activacin del botn '(axb)xc'
      if strcmp(asociar,'ab_c'),
         %Se omite el caso en que algn factor (o los 3) sea 0   
         if prodExacto ~= 0,
            %multiplicacin flotante (axb)xc
            s1 = op_flot(c,op_flot(a,b,'*'),'*');
            %Clculo del error relativo. Si  eps <= e.r. < 1 , el e.r. se 
            %escribe en notacin de punto flotante decimal con precisin t = 2.
            e1 = abs(prodExacto - valornum(s1))/abs(prodExacto);
            if e1 == 1, e1 = num2str(1);                         
            elseif  e1 <= eps, e1 = num2str(0);                     
            else e1 = guardar(e1,2); e1 = notacion(e1);          
            end                                                     
            acetato('','',['       (a x b) x c = ' notacion(s1)],'',['       El producto exacto es ' sprintf('%.10g',prodExacto)],'',['       e.r. : ' e1]);
            expl = str2mat('   Se muestra el producto  (a x b) x c  en notacin de punto flotante decimal',...
                          ['  con ' num2str(t) ' dgitos de precisin.'],...
                           ' ',...
                           '   Compare el producto flotante con el producto exacto.',...
                           ' ',...
                           '   e.r. es el error relativo de (a x b) x c.');
            set(NIPtexto,'String',expl);
         else  
            acetato('  OBSERVACION:','',' algn valor o los 3 valores son 0','',' Proporcione todos sus nmeros diferentes de 0');
            set(NIPtexto,'String','');
         end %if prodExacto ~= 0 
         
      %Activacin del botn 'ax(bxc)'
      elseif strcmp(asociar,'a_bc'),
         %Se omite el caso en que algn factor (o los 3) sea 0   
         if prodExacto ~= 0,
            %producto flotante ax(bxc)
            s2 = op_flot(a,op_flot(b,c,'*'),'*');
            %Clculo del error relativo. Si  eps <= e.r. < 1 , el e.r. se 
            %escribe en notacin de punto flotante decimal con precisin t = 2.
            e2 = abs(prodExacto - valornum(s2))/abs(prodExacto);
            if e2 == 1, e2 = num2str(1);                         
            elseif  e2 <= eps, e2 = num2str(0);                     
            else e2 = guardar(e2,2); e2 = notacion(e2);          
            end                                                     
            acetato('','',['       a x (b x c) = ' notacion(s2)],'',['       El producto exacto es ' sprintf('%.10g',prodExacto)],'',['       e.r. : ' e2]);
            expl = str2mat('   Se muestra el producto  a x (b x c)  en notacin de punto flotante decimal',...
                          ['  con ' num2str(t) ' dgitos de precisin.'],...
                           ' ',...
                           '   Compare el producto flotante con el producto exacto.',...
                           ' ',...
                           '   e.r. es el error relativo de a x (b x c).');
            set(NIPtexto,'String',expl);
         else  
            acetato('  OBSERVACION:','',' algn valor o los 3 valores son 0','',' Proporcione todos sus nmeros diferentes de 0');
            set(NIPtexto,'String','');
         end %if prodExacto ~= 0 
         
      %Activacin del botn '(axc)xb'
      elseif strcmp(asociar,'ac_b'),
         %Se omite el caso en que algn factor (o los 3) sea 0   
         if prodExacto ~= 0,
            %producto flotante (axc)xb
            s3 = op_flot(b,op_flot(a,c,'*'),'*');
            %Clculo del error relativo. Si  eps <= e.r. < 1 , el e.r. se 
            %escribe en notacin de punto flotante decimal con precisin t = 2.
            e3 = abs(prodExacto - valornum(s3))/abs(prodExacto);
            if e3 == 1, e3 = num2str(1);                         
            elseif  e3 <= eps, e3 = num2str(0);                     
            else e3 = guardar(e3,2); e3 = notacion(e3);          
            end                                                     
            acetato('','',['       (a x c) x b = ' notacion(s3)],'',['       El producto exacto es ' sprintf('%.10g',prodExacto)],'',['       e.r. : ' e3]);
            expl = str2mat('   Se muestra el producto  (a x c) x b  en notacin de punto flotante decimal',...
                          ['  con ' num2str(t) ' dgitos de precisin.'],...
                           ' ',...
                           '   Compare el producto flotante con el producto exacto.',...
                           ' ',...
                           '   e.r. es el error relativo de (a x c) x b.');
            set(NIPtexto,'String',expl);
         else  
            acetato('  OBSERVACION:','',' algn valor o los 3 valores son 0','',' Proporcione todos sus nmeros diferentes de 0');
            set(NIPtexto,'String','');
         end %if prodExacto ~= 0 
      end %if strcmp(asociar,...)         
   else
      errordlg('Introduzca sus nmeros antes de usar los botones y/o el men ''Precisin''','E R R O R');
   end %if ~isempty(get(dato1,'String')) & ...
   
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' ASOCIATIVIDAD DEL PRODUCTO DE 3 NUMEROS',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' En aritmtica exacta, para cualesquiera tres nmeros {\it a,b,c} \in R',...
      'se cumple',...
      '             ({\it a} \times {\it b}) \times {\it c}  =  {\it a} \times ({\it b} \times {\it c})',...
      'sin embargo en aritmtica de punto flotante puede ocurrir que ',...
      '             ({\it a} \times {\it b}) \times {\it c}  \neq  {\it a} \times ({\it b} \times {\it c})  ',...
      '',...
      ' Este ejemplo ilustra la repercusin de no cumplirse en general',...
      'la propiedad asociativa del producto de tres nmeros en la',...
      'computadora: Se obtienen diferentes resultados dependiendo',...
      'del orden en que se asocien los factores y de la precisin',...
      'con que se trabaje.',...
      ' Los nmeros utilizados son:',...
      '{\it a} = 1050  {\it b} = -25.55  {\it c} = 3.3333',...
      '',...
      ' Como ejercicio, usted puede escribir sus propios nmeros en la',...
      'ventana anterior situando el cursor en los campos editables y',...
      'borrando los valores actuales.','',...
      'Programa fuente: prod3num.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
     
end %if strcmp(entrada,...)
