function neutroad(entrada);
%NEUTROAD muestra la forma en que un nmero distinto de cero puede
%comportarse como el elemento neutro aditivo.
%
% Funcin creada por Fernando Saldaa jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' ELEMENTO NEUTRO ADITIVO',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .59]);
   
   %Comentarios de inicio
   indica = str2mat('   Tenemos los nmeros reales a y b. Note que a >> b > 0.',...
         ' ',...
         '   Utilizando el botn ''a+b'' y el men ''Precisin'' verifique para qu valores',...
         '  de t se tiene   a + b = a.',...
         '   Con el botn ''(a+b)-a'' y el men ''Precisin'' observe para qu valores de t',...
         '  se tiene   (a + b) - a = 0.',...
         '   El botn ''1/b'' calcula el inverso multiplicativo de b.');
   
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .34],...
             'BackgroundColor',[0 .8 0]);
   
   %El campo de explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .25],...
                        'Callback','neutroad(''eval'');',...
                        'String',indica);
                     
   %Los campos editables para que el usuario proporcione sus propios nmeros.
   %Inicialmente hay valores dados, los que constituyen el ejemplo.       
   dato1 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.15 .31 .18 .05],'String','10^5',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');
   dato2 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.48 .31 .18 .05],'String','0.125',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');        
                  
   %Los rtulos 'a =' y 'b =' 
   uicontrol('Style','text','Units','normalized',...
             'Position',[.12 .31 .03 .05],'String','a =',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.45 .31 .03 .05],'String','b =',...
             'Backgroundcolor',[0 .8 0]);
           
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR'
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Operaciones bsicas','Callback','campo;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller regresa;');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn 'a+b'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .86 .16 .06],...
             'String','a + b',...
             'Callback','neutroad(''ejecuta'');',...
             'UserData','ab');
   
   %Botn '(a+b)-a'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .78 .16 .06],...
             'String','(a + b) - a',...
             'Callback','neutroad(''ejecuta'');',...
             'UserData','aba');
   
   %Botn '1/b'
   uicontrol('Style','pushbutton','Units','normalized', ...
             'Position',[.8 .7 .16 .06],...
             'String','1 / b',...
             'Callback','neutroad(''ejecuta'');',...
             'UserData','rec_b');
   
   %Men 'precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .6 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .61 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .53 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','neutroad(''ejecuta'');',...
                    'Value',6);
       
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','neutroad(''info'');');
    
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Se guardan los campos editables, el cuadro de explicaciones y el men 'precisin'
   %pues se requerirn en la siguiente parte del programa.
   cambios = [dato1 dato2 NIPtexto prec];
   set(gcf,'UserData',cambios);
   
elseif strcmp(entrada,'ejecuta'), 
   
   %Se traen los objetos grficos salvados anteriormente
   cambios = get(gcf,'UserData');
   dato1 = cambios(1);
   dato2 = cambios(2);
   NIPtexto = cambios(3);
   prec = cambios(4);
   prop = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Obtencin de los nmeros introducidos por el usuario   
   if ~isempty(get(dato1,'String')) & ~isempty(get(dato2,'String')),   
      a_real = eval(get(dato1,'String'));
      b_real = eval(get(dato2,'String'));
      
      if a_real == 0 & b_real == 0,
         acetato('  OBSERVACION:','  a = b = 0');
         expl = str2mat(' ',...
                        '   Proporcione nmeros a,b distintos de 0',...
                        '  y de modo que |a| >> |b|');
         set(NIPtexto,'String',expl);
      else
         %La suma exacta de los nmeros de este ejemplo
         Exacta = a_real+b_real;
          
         %Se simula el guardar los nmeros reales en representacin interna
         %de una computadora que trabaja en base 10
         a = guardar(a_real,t);  
         b = guardar(b_real,t);  
         uno = guardar(1,t);  
        
         s = op_flot(a,b,'+');                     %suma a + b
         c = op_flot(op_flot(a,b,'+'),a,'-');      %cancelacin de a: (a+b)-a
         er = abs(Exacta - valornum(s))/abs(Exacta);   %error relativo de a+b
         
         %si eps <= e.r. < 1, el e.r. se escribe en notacin de punto flotante
         %decimal con precisin 2
         if er == 1, er = num2str(1);
         elseif er < eps, er = num2str(0);
         else er = guardar(er,2); er = notacion(er);
         end   
         
         %Activacin del botn 'a+b'
         if strcmp(prop,'ab'),
            if a_real ~=0 & b_real == 0,
               acetato('  OBSERVACION:',' b = 0 es el elemento neutro aditivo de los nmeros reales','',['      a = ' notacion(a)],'      b = 0',['     a + b = ' notacion(a)]);
               expl = str2mat('',...
                  '   Proporcione un nmero b distinto de 0 y de modo que |b| << |a|',...
                  '',...
                 ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
              set(NIPtexto,'String',expl);
            elseif a_real == 0 & b_real ~=0,
              acetato('  OBSERVACION:',' a = 0 es el elemento neutro aditivo de los nmeros reales','','      a = 0',['      b = ' notacion(b)],['     a + b = ' notacion(b)]);
              expl = str2mat('',...
                  '   Proporcione un nmero a distinto de 0 y de modo que |a| >> |b| > 0',...
                  '',...
                 ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
              set(NIPtexto,'String',expl);
            elseif a_real ~= 0 & b_real ~= 0,
              acetato('','',['      a = ' notacion(a)],['      b = ' notacion(b)],['     a + b = ' notacion(s)],'',['      La suma exacta es: ' sprintf('%.10g',Exacta)],['      e. r.: ' er]);
              expl = str2mat('   Se muestran los nmeros a,b as como la suma de ellos en notacin',...
                      ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                       ' ',...
                       '   Observe en la suma flotante si b fue considerado como el neutro aditivo.',...
                       ' ',...
                       '   e.r. es el error relativo de  a + b');
              set(NIPtexto,'String',expl);
            end %if a_real ~= 0 & b_real == 0        
            
         %Activacin del botn '(a+b)-a'   
         elseif strcmp(prop,'aba'),
            if a_real ~= 0 & b_real == 0,
               acetato('  OBSERVACION:',' Puesto que b = 0',' entonces (a + b) - a = a - a = 0');
               expl = str2mat('',...
                  '   Proporcione un nmero b distinto de 0 y de modo que |b| << |a|',...
                  '',...
                 ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
               set(NIPtexto,'String',expl);
            elseif a_real == 0 & b_real ~= 0,
               acetato('  OBSERVACION:',' Puesto que a = 0',[' entonces (a + b) - a = b = ' notacion(b)]);
               expl = str2mat('',...
                  '   Proporcione un nmero a distinto de 0 y de modo que |a| >> |b| > 0',...
                  '',...
                 ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
               set(NIPtexto,'String',expl);
            elseif a_real ~= 0 & b_real ~= 0,
               acetato('','',['      a = ' notacion(a)],['      b = ' notacion(b)],['      (a + b) - a = ' notacion(c)]);
               expl = str2mat('   Se muestran los nmeros a,b as como la operacin que contribuye',...
                    '  a la cancelacin del nmero a, en notacin de punto flotante decimal',...
                   ['  de ' num2str(t) ' dgitos de precisin.'],...
                    ' ',...
                    '  Observe si como resultado de la cancelacin de a obtenemos el nmero b.');
               set(NIPtexto,'String',expl);
            end %if a_real ~= 0 & b_real == 0
            
         %Activacin del botn '1/b'   
         elseif strcmp(prop,'rec_b'),
           if b_real == 0,
             acetato('  OBSERVACION:','  b = 0');
             expl = str2mat('   Puesto que b = 0, b no tiene inverso multiplicativo',...
               ' ',...
              ['  Se trabaja con ' num2str(t) ' dgitos de precisin.']);
             set(NIPtexto,'String',expl);
           else 
             r = op_flot(uno,b,'/'); id = op_flot(b,r,'*');
             acetato('','',['      b = ' notacion(b)],['      b^{-1} = ' notacion(r)],['      b b^{-1} = ' num2str(valornum(id))]);
             expl = str2mat('   Puesto que b es distinto de 0, b tiene inverso multiplicativo.',...
                      ' ',...
                      '   Tanto b como su recproco se muestran en notacin de punto flotante decimal',...
                     ['  con ' num2str(t) ' dgitos de precisin.']);
             set(NIPtexto,'String',expl);
           end %if b_real == 0
         end %if strcmp(prop,...)   
      end %if a_real == 0 & b_real == 0
      
   else
      errordlg('Introduzca sus nmeros antes de usar los botones y/o el men ''Precisin''','E R R O R');
   end %if ~isempty(get(dato1,'String')) & ...
   
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' ELEMENTO NEUTRO ADITIVO',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' En aritmtica exacta,',...
      '             si {\it a,b} \in R  y {\it a} + {\it b} = {\it a}  \Rightarrow {\it b} = 0.',...
      'Sin embargo en aritmtica de punto flotante puede ocurrir que ',...
      '             {\it a} + {\it b} = {\it a}    pero    {\it b} \neq 0',...
      '',...
      ' Con este ejemplo se ilustra el fenmeno numrico de que un',...
      'valor distinto de 0 se comporte como el elemento neutro',...
      'aditivo. Se trabaja con los nmeros:',...
      '  {\it a} = 10^{5}      {\it b} = 0.125',...
      ' Debido a que {\it a} es mucho ms grande en valor absoluto en',...
      'relacin a {\it b}, el fenmeno {\it a} + {\it b} = {\it a} ocurre cuando para ',...
      'alguna precisin el valor {\it b} no contribuye a la suma.',...
      '',...
      ' Como ejercicio, usted puede escribir sus propios nmeros en la',...
      'ventana anterior situando el cursor en los campos editables y',...
      'borrando los valores actuales.','','',...
      'Programa fuente: neutroad.m');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
   
end %if strcmp(entrada,...)