function mimqn(entrada);
%MIMQN presenta los parmetros del sistema de nmeros de punto flotante
%de la computadora anfitrin.
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' "MI COMPUTADORA"',...
   'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .1 .7 .8]);
      
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del Taller 
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
     
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
    
        
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','mimqn(''info'');');
   
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
        
   %Clculo de la base beta
   a = 1;
   while (a+1)-a == 1,
      a = 2*a;
   end
   b = 2;
   while (a+b) == a,
      b = 2*b;
   end
   beta = (a+b)-a;
   if beta == 2,
      betadigitos = str2mat('bites');
   elseif beta == 8,
      betadigitos = str2mat('octadgitos');
   elseif beta == 10,
      betadigitos = str2mat('dgitos');
   elseif beta == 16,
      betadigitos = str2mat('hexadgitos');
   end   
   
   %Clculo de la precisin t
   t = 1;
   a = beta;
   while (a+1)-a == 1,
      t = t+1;
      a = a*beta;
   end   
   
   %Se calcula la unidad de redondeo u
   epsilon = 1;
   while (1 + epsilon) > 1,
      epsilon = epsilon/2;
   end
   epsilon = 2*epsilon;
   u = epsilon/2;
    
   %Clculo del exponente mnimo m
   x = 1; m = 0;
   while x > 0,
      x = x/10; m = m-1;
   end   
    
   %Clculo del exponente mximo M
   x = 1; M = 0;
   while x ~= Inf,
      x = x*10; M = M+1;
   end
   
   %Se determina si la computadora trunca o redondea
   redondeo = 0;
   if (a+(beta/2)) - a ~= 0,
      redondeo = 1;
   end
   if (redondeo == 0) & ((a+beta+(beta/2)) - (a+beta) ~= 0),
      redondeo = 2;
   end
   if redondeo == 0,
      red = str2mat('trunca');
   elseif redondeo == 1,
      red = str2mat('redondea');
   elseif redondeo == 2,
      red = str2mat('redondea segn la norma IEEE');
   end
    
   acetato(' La computadora que usted utiliza trabaja internamente',['en base \beta = ' num2str(beta) '.'],[' La precisin de la misma es {\it t} = ' num2str(t) ' ' betadigitos '.'],' La unidad de redondeo de su mquina es',['{\it u} = ' num2str(u) '.'],[' Exponente {\it m} = ' num2str(m) '. Exponente {\it M} = ' num2str(M) '.'],'',['Adems esta computadora ' red '.']);
 
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' "MI COMPUTADORA"',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' ',...
      '  Ya que la computadora es indispensable como instrumento',...
      ' de trabajo para el cmputo cientfico, es indudable que',...
      ' entre las primeras cualidades que deben conocerse de la',...
      ' mquina estn los parmetros que definen su sistema',...
      ' de punto flotante.',...
      ' ',...
      ' Con la implementacin de sencillas instrucciones en Matlab',...
      'utilizando ciclos-while es posible determinar la base \beta,',...
      'la precisin {\it t}, la unidad de redondeo {\it u}, as como',...
      'los exponentes mnimo {\it m} y mximo {\it M} de la mquina',...
      'en que se trabaja.',...
      ' ',...
      ' ',...
      ' ',...
      ' ',...
      ' ',...
      ' ',...
      'Programa fuente: mimqn.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
 
end %if strcmp(entrada,...)
