function explicac(titulo,texto1,texto2,texto3);
%EXPLICAC se utiliza para redactar la presentacin del Taller y las
%referencias bibliogrficas.
%
% De entrada:
% titulo es una cadena de caracteres que consta de una palabra o un rengln.
% texto1, texto2 y texto3 es la redccin consistente en hasta 25 renglones.
%
% Funcin creada por Fernando Saldaa Jimnez, basada en helpfun
% Ultima fecha de modificacin: 30 noviembre 2000

paginas = nargin-1;
if nargin<4,
    texto3 = ' ';
end
if nargin<3,
    texto2 = ' ';
end

figNumber = figure('Units','normalized','Name','TALLER DE ANALISIS NUMERICO',...
        'NumberTitle','off','Menubar','none','Visible','on','Position',[.14 .2 .7 .7]);

%El marco del texto de informacin
uicontrol('Style','frame','Units','normalized',...
          'Position',[.03 .03 .74 .94], ...
          'BackgroundColor',[0 .8 0]);
       
%El rtulo (ttulo) en la parte superior del marco
NIPtitulo = uicontrol('Style','text','Units','normalized',...
                  'Position',[.05 .9 .7 .05],...
                  'BackgroundColor',[0 .6 0],...
                  'ForegroundColor',[1 1 1],...
                  'String',titulo);
               
%Creacin de hasta 3 campos para la informacin (explicaciones)               
for i = 1:3,
    explic = eval(['texto',num2str(i)]);
    explicacion(i) = uicontrol('Style','text',...
            'HorizontalAlignment','left',...
            'Units','normalized',...
            'Max',20,...
            'String',explic,...
            'BackgroundColor',[1 1 1],...
            'Visible','off',...
            'Position',[.05 .05 .7 .845]);
end
     
%Aparece de inicio la explicacin de la pgina 1
set(explicacion(1),'Visible','on');
  
%La consola y los botones
uicontrol('Style','frame','Units','normalized',...
        'Position',[.78 .03 .19 .94],...
        'BackgroundColor',[0 .8 0]);
     
%Creacin de hasta 3 botones con rtulo 'Pgina _'    
for j = 1:3
    acciones = ...
           ['expl = get(gco,''UserData'');' ...
            'cambios = get(gcf,''UserData'');' ...
            'set(cambios(2:4),''Visible'',''off'');' ...
            'set(expl,''Visible'',''on'');'];
    boton(j)=uicontrol( ...
            'Style','pushbutton', ...
            'Units','normalized', ...
            'Position',[.8 (.85-(j-1)*(.1)) .15 .06], ...
            'String',['Pgina ',num2str(j)],...
            'UserData',explicacion(j),...
            'Visible','off',...
            'Callback',acciones);
end

%El botn 'Cerrar'
uicontrol('Style','pushbutton','Units','normalized',...
          'Position',[.8 .05 .15 .06],...
          'String','C e r r a r',...
          'Callback','close(gcf)');

cambios = [NIPtitulo explicacion boton];
        
set(figNumber,'UserData',cambios);
    
%Colocacin de los campos con las explicaciones y los botones
cambios = get(figNumber,'UserData');
NIPtitulo = cambios(1);
explicacion = cambios(2:4);
boton = cambios(5:7);
set(NIPtitulo,'String',titulo);
set(explicacion(2:3),'Visible','off');
set(explicacion(1),'Visible','on');
set(explicacion(1),'String',texto1);
set(explicacion(2),'String',texto2);
set(explicacion(3),'String',texto3);

%Aparicin de los botones necesarios
if paginas == 1,
    set(boton,'Visible','off');
elseif paginas == 2,
    set(boton,'Visible','off');
    set(boton(1:2),'Visible','on');
elseif paginas == 3,
    set(boton(1:3),'Visible','on');
end

