function e_taylor(entrada);
%E_TAYLOR calcula el valor numrico de e^(-5.5) 
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' E X P O N E N C I A L   D E   x , x < 0',...
   'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .6]);
      
   acetato(' Calcular','\fontsize{35}           \it e','',' mediante la serie de Taylor:','',' \Sigma_{n=0}^{\infty} x^n / n! = e^x');
   
 %Comentarios de inicio
 indica = str2mat(' ',...
     '   Presione el botn ''Valor'' para calcular una aproximacin al valor',...
     '  de la exponencial del nmero escrito.',...
     ' ',...
     '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
     '  longitud de mantisa. Enseguida vuelva a utilizar el botn ''Valor''.');
   
 %El marco del cuadro de comentarios y explicaciones
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.03 .03 .74 .34],...
           'BackgroundColor',[0 .8 0]);
   
 %El campo de explicaciones
 NIPtexto = uicontrol('Style','text','Units','normalized',...
                      'HorizontalAlignment','left',...
                      'Max',10,...
                      'BackgroundColor',[1 1 1],...
                      'Position',[.05 .05 .7 .3],...
                      'Callback','e_taylor(''eval'');',...
                      'String',indica);
   
 %Men 'VENTANA'
 vent = uimenu(figNumber,'Label','VENTANA');
 uimenu(vent,'Label','Imprimir','Callback','print');
 uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
 %Men 'REGRESAR' a mdulos anteriores del Taller  
 retorno = uimenu(figNumber,'Label','REGRESAR');
 uimenu(retorno,'Label','a men de Cancelacin','Callback','cancenum;');
 uimenu(retorno,'Label','a T e m a s','Callback','temas;');
 uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
 
 %El campo editable para que el usuario proporcione sus propios nmeros.
 %Inicialmente hay un valor dado, el que constituye el ejemplo.       
 dato = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.37 .86 .08 .05],'String','-5.5',...
                     'HorizontalAlignment','left');
 
 %La consola de botones y menus de control
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.78 .03 .2 .94],...
           'BackgroundColor',[0 .8 0]);
    
 %Botn 'Valor de la serie'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .8 .16 .06],...
           'String','V a l o r',...
           'Callback','e_taylor(''ejecuta'');',...
           'UserData','porTaylor');
   
 %Men 'precisin'
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.81 .7 .14 .05],...
           'BackgroundColor',[.6 .8 1]);
 uicontrol('Style','text','Units','normalized',...
           'Position',[.82 .71 .12 .03],...
           'BackgroundColor',[.6 .8 1],...
           'ForegroundColor',[0 0 0],...
           'String','Precisin');
 prec = uicontrol('Style','popupmenu','Units','normalized',...
                  'Position',[.81 .63 .14 .07],...
                  'String',str2mat(' t = 1',' t = 2',' t = 3',' t = 4',...
                              ' t = 5',' t = 6',' t = 7',' t = 8',...
                              ' t = 9',' t = 10',' t = 11',' t = 12',...
                              ' t = 13',' t = 14',' t = 15',' t = 16'),...
                  'Callback','e_taylor(''ejecuta'');',...
                  'Value',5);
       
 %Botn INFO
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .15 .16 .06],...
           'String','I n f o',...
           'Callback','e_taylor(''info'');');
   
 %Botn 'Salir'
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .07 .16 .06],...
           'String','S a l i r',...
           'Callback','close(gcf)');
   
 %Guardar el valor x, el cuadro de explicaciones y el men 'precisin' 
 cambios = [dato NIPtexto prec];
 set(gcf,'UserData',cambios);
 
elseif strcmp(entrada,'ejecuta'),
   
 %Se traen los objetos grficos salvados con anterioridad   
 cambios = get(gcf,'UserData');
 dato = cambios(1);
 NIPtexto = cambios(2);
 prec = cambios(3);
 valor = get(gco,'UserData');  
 t = get(prec,'Value');
 
 if ~isempty(get(dato,'String')),
    a = eval(get(dato,'String'));
    %Activacin del botn 'Valor'
    if strcmp(valor,'porTaylor'),
       x = guardar(a,t);
       y0 = guardar(0,t);
       termino = guardar(1,t);
       yf = termino;
       n = 0;
       while valornum(yf) ~= valornum(y0),
          n = n+1;
          ene = guardar(n,t);
          xn = op_flot(x,termino,'*');
          termino = op_flot(xn,ene,'/');
          y0 = yf;
          yf = op_flot(yf,termino,'+');
       end
       er = abs(exp(a) - valornum(yf))/abs(exp(a));
       if er == 1,
          er = num2str(1);
       elseif er == 0,
          er = num2str(0);
       else
          er = guardar(er,2); er = notacion(er);
       end
       acetato(' El valor de','\fontsize{35}           \it e','',[' es ' notacion(yf)],'',' El valor correcto es',[' e^{' sprintf('%.5g',a) '} = ' sprintf('%.16g',exp(a))],'',[' e.r. ' er]);
       if a < 0,
          expl = str2mat(' ',...
             ['   Se muestra el valor numrico de e^(' sprintf('%.5g',a) ') en notacin de punto flotante'],...
             ['  decimal con ' num2str(t) ' dgitos de precisin.'],...
              ' ',...
              '   Compare el valor numrico con el valor correcto.',...
              ' ',...
             ['   e.r. es el error relativo del clculo de e^(' sprintf('%.5g',a) ')']);
       else
          expl = str2mat(' ',...
             '   A fin de poder apreciar el efecto de la cancelacin numrica en el clculo',...
             '  de e^x, introduzca un valor x < 0.',...
             ' ',...
            ['   Se muestra el valor numrico de e^(' sprintf('%.5g',a) ') en notacin de punto flotante'],...
            ['  decimal con ' num2str(t) ' dgitos de precisin.']);
            
       end
       set(NIPtexto,'String',expl);
    end %if strcmp(valor,'porTaylor'), 
 else
      errordlg('Introduzca su nmero antes de usar el botn y/o el men ''Precisin''','E R R O R');
 end %if ~isempty(get(dato,'String'))

elseif strcmp(entrada,'info'),
   figNumber = figure('Units','normalized','Name',' E X P O N E N C I A L   D E   x , x < 0',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' Para cualquier valor de {\it x} es posible calcular {\it e^{x}} mediante',...
      'la serie de Taylor',...
      '                  {\it e^{x}} = 1 + {\it x} + {\it x}^{2}/2! + {\it x}^{3}/3! + \cdot \cdot \cdot',...
      'pero cuando {\it x} < 0, la suma anterior se convierte en una serie',...
      'alternante de trminos positivos y negativos lo que propicia',...
      'en la computadora el efecto de cancelacin numrica.',...
      ' ',...
      ' Una forma de evitar este problema -sin utilizar una precisin',...
      'ms grande- es calcular primero la exponencial del valor',...
      'absoluto de {\it x} (para evitar las restas) y enseguida encontrar',... 
      'el recproco del resultado anterior.',...
      ' ',...
      ' ',...
      ' ',...
      ' Como ejercicio, usted puede escribir valores de {\it x} < 0 en la',...
      'ventana anterior situando el cursor en el campo editable y',...
      'borrando el valor actual.','',...
      'Programa fuente: e\_taylor.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');

end %if strcmp(entrada,...)