function cancenum(entrada);
%CANCENUM Crea la ventana que rene los ejemplos con los que se ilustra
%el fenmeno de cancelacin numrica.
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima Fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' EL FENOMENO DE CANCELACION NUMERICA',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   %Propsito del tema
   indica = str2mat(' ',...
            '   Propsito del tema: ',...
            '',...
            '  Destacar la posible ocurrencia del fenmeno de cancelacin',...
            '  numrica o catastrfica cuando en un algoritmo programado',...
            '  en la computadora interviene la sustraccin de 2 nmeros.',...
            '  muy cercanos entre s.',...
            '','','','','','',...
            '   Instrucciones: Oprima alguno de los botones de la parte',...
            '  superior derecha segn el ejemplo que desee estudiar.');
   
   %El marco del propsito e instrucciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.05 .25 .6 .55],...
             'BackgroundColor',[1 1 1]);
   
   %El campo del propsito e instrucciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',15,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.07 .27 .56 .51],...
                        'String',indica);
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del Taller  
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
    
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.7 .03 .27 .94],...
             'BackgroundColor',[0 .8 0]);
    
   %Botn 'Resta a-b'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .85 .23 .06],...
             'String','Resta a - b',...
             'Callback','cercanos(''iniciar'');');
        
   %Botn 'Area de tringulos'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .77 .23 .06],...
             'String','Area de tringulos',...
             'Callback','triangul(''iniciar'');');
      
   %Botn 'Exponencial de x'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .69 .23 .06],...
             'String','Exponencial de x',...
             'Callback','e_taylor(''iniciar'');');
      
   %Botn 'Media y varianza'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .61 .23 .06],...
             'String','Media y varianza',...
             'Callback','medyvar(''iniciar'');');
      
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.72 .07 .23 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
        
end %if strcmp(entrada,...)