function sumas(entrada);
%SUMAS rene los ejemplos de las series contempladas en
%s1_2alan, s1_n_al2 y serie1_n.
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close 
   figNumber = figure('Units','normalized','Name',' S U M A S  (S E R I E S)',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   %Propsito del tema
   indica = str2mat(' ',...
    '   Propsito del tema: ',' ',...
    '  Mostrar que la operacin suma no es de ningn modo trivial',...
    '  en Aritmtica de Punto Flotante.',...
    '',...
    '  Para ello se calcula numricamente el valor de conocidas',...
    '  series, primero sumando sus trminos en orden decreciente',...
    '  (es decir, los trminos que contribuyen a la suma son',...
    '  previamente ordenados del mayor al menor en magnitud)',...
    '  y enseguida este mismo nmero de trminos se suma en',...
    '  orden creciente (es decir, ordenados del menor al mayor',...
    '  en valor absoluto).','','',...
    '   Instrucciones: Al elegir alguno de los ejemplos de la derecha',...
    '  oprima el botn correspondiente (colocado debajo de la',...
    '  serie que ha seleccionado).');
   
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.05 .2 .6 .6],...
             'BackgroundColor',[1 1 1]);
    
   %El campo del propsito e instrucciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',15,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.07 .22 .56 .56],...
                        'String',indica);
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del Taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
      
   %La consola de botones y menus de control
   axes('Units','normalized','Box','on','XTick',[],'YTick',[],'Visible','on',...
        'Position',[.7 .03 .27 .94],...
        'Color',[0 .8 0]);
    
   %El rtulo 'Ejemplos'
   uicontrol('Style','text','Units','normalized',...
             'Position',[.76 .91 .15 .04],...
             'BackgroundColor',[.0 .8 0],...
             'ForegroundColor',[0 0 0],...
             'String','Ejemplos:');
        
   %El cuadro y botn del ejemplo 1       
   axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.71 .78 .25 .12]);
   acetato('','\fontsize{9}  serie    \Sigma_{n=1}^{\infty} 1/n');
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .79 .23 .05],...
             'Callback','serie1_n(''iniciar'');');
        
   %El cuadro y botn del ejemplo 2       
   axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.71 .64 .25 .12]);
   acetato('','\fontsize{9}  serie    \Sigma_{n=1}^{\infty} 1/ 2^n');
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .65 .23 .05],...
             'Callback','s1_2alan(''iniciar'');');
        
   %El cuadro y botn del ejemplo 3       
   axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.71 .5 .25 .12]);
   acetato('','\fontsize{9}  serie    \Sigma_{n=1}^{\infty} 1/ n^2');
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .51 .23 .05],...
             'Callback','s1_n_al2(''iniciar'');');
      
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.72 .07 .23 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
  
 
end %if strcmp(entrada,...)