function suma1s(entrada);
%SUMA1S efecta la suma de 1200 1's, asocindolos de tres maneras diferentes.
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' ASOCIATIVIDAD DE LA SUMA DE 1200 1''S',...
   'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','off');
   
 axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .6]);
   
 acetato('','  Calcular el valor de la suma','','                              1,200 ','\fontsize{40}         \Sigma  1','                                 1');
   
 %Comentarios de inicio
 indica = str2mat(' ',...   
      '  Oprima alguno de los botones del tablero ''Sumar asociando'' segn la forma',...
      ' en que desea se agrupen los 1''s. Observe el resultado de dicha asociacin.',...
      ' ',...
      '   Para trabajar con un nuevo valor de t abra el men  ''Precisin''  y elija su ',...
      '  longitud de mantisa. Enseguida vuelva a utilizar los botones.');

   
 %El marco del cuadro de comentarios y explicaciones
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.03 .03 .74 .34],...
           'BackgroundColor',[0 .8 0]);
   
 %El rtulo COMENTARIOS Y EXPLICACIONES
 uicontrol('Style','text','Units','normalized',...
           'Position',[.05 .3 .7 .05],...
           'BackgroundColor',[0 .6 0],...
           'ForegroundColor',[1 1 1],...
           'String','COMENTARIOS Y EXPLICACIONES');
   
 %El campo editable de explicaciones
 NIPtexto = uicontrol('Style','text','Units','normalized',...
                      'HorizontalAlignment','left',...
                      'Max',10,...
                      'BackgroundColor',[1 1 1],...
                      'Position',[.05 .05 .7 .25],...
                      'Callback','suma1s(''eval'');',...
                      'String',indica);
   
 %Men 'VENTANA'
 vent = uimenu(figNumber,'Label','VENTANA');
 uimenu(vent,'Label','Imprimir','Callback','print');
 uimenu(vent,'Label','Cerrar','Callback','close(gcf)');

 %Men 'REGRESAR' a mdulos anteriores del taller
 retorno = uimenu(figNumber,'Label','REGRESAR');
 uimenu(retorno,'Label','a men de Operaciones bsicas','Callback','campo;');
 uimenu(retorno,'Label','a T e m a s','Callback','temas;');
 uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
 
 %La consola de botones y menus de control
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.78 .03 .2 .94],...
           'BackgroundColor',[0 .8 0]);
   
 %El tablero de botones
 uicontrol('Style','frame','Units','normalized', ...
           'Position',[.79 .62 .18 .33],...
           'BackgroundColor',[.6 .8 1]);
 uicontrol('Style','text','Units','normalized',...
           'Position',[.8 .89 .16 .03],...
           'BackgroundColor',[.6 .8 1],...
           'ForegroundColor',[0 0 0],...
           'String','Sumar asociando:');

 %botn 'asocia de 1 en 1'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .8 .16 .06],...
           'String','de 1 en 1',...
           'Callback','suma1s(''ejecuta'');',...
           'UserData','uno');
   
 %botn 'asocia en grupos de 4'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .72 .16 .06],...
           'String','en grupos de 4',...
           'Callback','suma1s(''ejecuta'');',...
           'UserData','cuatro');
   
 %botn 'asocia en grupos de 10'
 uicontrol('Style','pushbutton','Units','normalized', ...
           'Position',[.8 .64 .16 .06],...
           'String','en grupos de 8',...
           'Callback','suma1s(''ejecuta'');',...
           'UserData','ocho');
   
 %men 'Precisin'
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.81 .47 .14 .05],...
           'BackgroundColor',[.6 .8 1]);
 uicontrol('Style','text','Units','normalized',...
           'Position',[.82 .48 .12 .03],...
           'BackgroundColor',[.6 .8 1],...
           'ForegroundColor',[0 0 0],...
           'String','Precisin');
 prec = uicontrol('Style','popupmenu','Units','normalized',...
                  'Position',[.81 .4 .14 .07],...
                  'String',' t = 1| t = 2| t = 3| t = 4',...
                  'Callback','suma1s(''ejecuta'');',...
                  'Value',2);
       
 %botn INFO
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .15 .16 .06],...
           'String','I n f o',...
           'Callback','suma1s(''info'');');
   
 %botn cerrar
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .07 .16 .06],...
           'String','S a l i r',...
           'Callback','close(gcf)');
   
 %Guardar el cuadro de explicaciones y el men 'precisin'
 cambios = [NIPtexto prec];
 %Descubrir la ventana
 set(gcf,'Visible','on','UserData',cambios); 
  
elseif strcmp(entrada,'ejecuta'),
   
 %Se traen los objetos grficos salvados con anterioridad
 cambios = get(gcf,'UserData');
 NIPtexto = cambios(1);
 prec = cambios(2);
 bloque = get(gco,'UserData');  
 t = get(prec,'Value');
 k = guardar(0,t);
 u = guardar(1,t);
           
 if strcmp(bloque,'uno'),
    for i = 1:1200 k = op_flot(k,u,'+'); end 
    acetato('',' El resultado numrico es','',['     \Sigma_{1}^{1200} 1 = ' notacion(k)],['                 = ' sprintf('%.4g', valornum(k))],'','',' El resultado correcto es \Sigma_{1}^{1200} 1 = 1200.');
    expl = str2mat(' ',...
    ['   Se expresa la suma en notacin de punto flotante decimal con ' num2str(t) ' dgitos'],...
     '  de precisin as como su valor numrico.',...
     ' ',...
     '   La asociacin de los 1''s realizada de 1 en 1 se puede representar as:',...
     ' ',...
     '                          (...(((((1+1)+1)+1)+1)+1)...+1)',...
     ' ');
    set(NIPtexto,'String',expl);
                  
 elseif strcmp(bloque,'cuatro'),
    for i = 1:300
       b = guardar(0,t);
       for j = 1:4
          b = op_flot(b,u,'+');
       end
       k = op_flot(k,b,'+');
    end
    acetato('',' El resultado numrico es','',['     \Sigma_{1}^{1200} 1 = ' notacion(k)],['                 = ' sprintf('%.4g', valornum(k))],'','',' El resultado correcto es \Sigma_{1}^{1200} 1 = 1200.');
    expl = str2mat(' ',...
    ['   Se expresa la suma en notacin de punto flotante decimal con ' num2str(t) ' dgitos'],...
     '  de precisin as como su valor numrico.',...
     ' ',...
     '   La asociacin de los 1''s en bloques de 4 se puede representar as:',...
     ' ',...
     '             ...{{[(((1+1)+1)+1)]+[(((1+1)+1)+1)]}+[(((1+1)+1)+1)]}...',...
     ' ');
    set(NIPtexto,'String',expl);
 elseif strcmp(bloque,'ocho'),
        for i = 1:150
            b = guardar(0,t);
            for j = 1:8
               b = op_flot(b,u,'+');
            end   
            k = op_flot(k,b,'+'); 
        end
     acetato('',' El resultado numrico es','',['     \Sigma_{1}^{1200} 1 = ' notacion(k)],['                 = ' sprintf('%.4g', valornum(k))],'','',' El resultado correcto es \Sigma_{1}^{1200} 1 = 1200.');
     expl = str2mat(' ',...
      ['   Se expresa la suma en notacin de punto flotante decimal con ' num2str(t) ' dgitos'],...
     '  de precisin as como su valor numrico.',...
     ' ',...
     '   La asociacin de los 1''s en bloques de 8 se puede representar as:',...
     ' ',...
     '       ...{{[(((((((1+1)+1)+1)+1)+1)+1)+1)]+[(((((((1+1)+1)+1)+1)+1)+1)+1)]}',...
     '           +[(((((((1+1)+1)+1)+1)+1)+1)+1)]}...',...
     ' ');
     set(NIPtexto,'String',expl);
 end %if strcmp(bloque,...)   
                  
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' ASOCIATIVIDAD DE LA SUMA DE 1200 1''S',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' Si en una computadora se tienen los nmeros {\it a}_{1},{\it a}_{2},...,{\it a}_{n}',...
      'el resultado de la suma de ellos:',...
      '                                         \Sigma_{i=1}^{n} {\it a}_{i}',...
      'puede tener diferentes resultados dependiendo de la forma en',...
      'que se asocien dichos nmeros y de la precisin de la mquina.',...
      ' Como ejemplo se presenta la suma trivial',...
      '                                         \Sigma_{1}^{1200} 1',...
      'asociando los 1''s de tres formas diferentes:',...
      '1. {\it Asociacin Anidada  recursiva} . Esto es, los 1''s se van',...
      'aadiendo uno por uno al resultado parcial hasta completar',...
      'los 1200 1''s.',...
      '2. {\it Asociacin en grupos de 4}. Se asocian en forma anidada',...
      '4 1''s, se suman y enseguida dicho valor se aade al resultado',...
      'parcial. Se repiten los pasos anteriores hasta completar la suma.',...
      '3. {\it Asociacin en grupos de 8}. Se realiza el mismo procedimiento',...
      'de la asociacin anterior pero con paquetes de 8 1''s.',...
      ' ',...
      ' ',...
      'Programa fuente: suma1s.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
 
end %if strcmp(entrada,...)
        