function z = op_flot(x,y,op)
%OP_FLOT efectua la operacin op entre dos nmeros de punto flotante
% De entrada:
% x,y son vectores rengln provenientes de la funcin guardar que 
%     simulan nmeros de punto flotante.
% z es el resultado de la operacin aritmtica, guardado como
%   un nmero de punto flotante.
%
% Funcin implementada por Fernando Saldaa Jimnez, basada en float.m
% (Introduction to Scientific Computing: A Matrix-Vector Approach 
% Charles F. Van Loan)
% Ultima fecha de modificacin: 30 noviembre 2000

format long g;
t = length(x)-1;
sx = valornum(x);
sy = valornum(y);

if op == '+'
   c = sx + sy;
elseif op == '-'
   c = sx - sy;
elseif op == '*'
   c = sx*sy;
elseif op == '/'
   if sy == 0
      error('Divisin entre cero');
   else c = sx/sy;
   end
end

z = guardar(c,t);