function medyvar(entrada);
%MEDYVAR calcula la media y varianza de un conjunto de datos dados mediante
%los mtodos de 1 paso y de 2 pasos.
%
% Funcin creada por Fernando Saldaa jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' MEDIA Y VARIANZA MUESTRALES',...
   'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .59]);
      
   %Comentarios de inicio
   indica = str2mat('   Oprima alguno de los botones de la parte derecha superior segn el mtodo',...
          '  que elija para encontrar la media y varianza de los valores escritos en el vector',...
          '  ''datos''.',...
          ' ',...
          '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
          '  longitud de mantisa. Enseguida vuelva a utilizar los botones.');
   
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .34],...
             'BackgroundColor',[0 .8 0]);
      
   %El campo de explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .25],...
                        'Callback','medyvar(''eval'');',...
                        'String',indica);
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');  
   
   %Men 'REGRESAR' a mdulos anteriores del Taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Cancelacin','Callback','cancenum;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
        
   %El rtulo 'datos ='
   uicontrol('Style','text','Units','normalized',...
             'Position',[.05 .31 .08 .05],'String','datos =',...
             'Backgroundcolor',[0 .8 0]);
           
   %El campos editable para que el usuario proporcione sus propios datos
   %dentro del vector. Inicialmente hay valores dados, los que constituyen el ejemplo.       
   datos = uicontrol('Style','edit','Units','normalized',...
              'Position',[.13 .31 .55 .05],'String','[10000 10001 10002]',...
              'Backgroundcolor',[1 1 1],...
              'HorizontalAlignment','left');
              
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn 'Mtodo de 1 paso'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .86 .16 .06],...
             'String','Mtdo. de 1 paso',...
             'Callback','medyvar(''ejecuta'');',...
             'UserData','unpaso');
   
   %Botn 'Mtodo de 2 pasos'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .78 .16 .06],...
             'String','Mtdo. de 2 pasos',...
             'Callback','medyvar(''ejecuta'');',...
             'UserData','dospasos');
     
   %Men 'Precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .68 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .69 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .61 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','medyvar(''ejecuta'');',...
                    'Value',7);
       
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','medyvar(''info'');');
     
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Guardar el cuadro de explicaciones y el men 'Precisin' 
   cambios = [datos NIPtexto prec];
   set(gcf,'UserData',cambios);
    
elseif strcmp(entrada,'ejecuta'), 
   
   %Se traen los objetos grficos salvados con anterioridad  
   cambios = get(gcf,'UserData');
   datos = cambios(1);
   NIPtexto = cambios(2);
   prec = cambios(3);
   metodo = get(gco,'UserData');  
   t = get(prec,'Value');
       
   if isempty(get(datos,'String')),
      acetato(' OBSERVACION:','El tamao de la muestra es n = 0','','NO es posible calcular media y varianza.');
      expl = str2mat( ...
         '   En el campo editable a la derecha de la palabra ''datos'' escriba corchetes [ ]',...
         '  (si no los hay) y dentro de los mismos introduzca sus valores dejando un espacio',...
         '  entre dato y dato.',...
         ' ',...
        ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
       set(NIPtexto,'String',expl);
   else
       x = eval(get(datos,'String'));
       n = length(x);
       uno = guardar(1,t);
       if n == 1,
          acetato(' OBSERVACION:','El tamao de la muestra es n = 1','',[' La media muestral es: ' notacion(guardar(x,t))],' La varianza es 0.');
          expl = str2mat( ...
                 '   Puesto que la muestra est formada por un solo dato, la media muestral',...
                 '  es dicho dato. Debido a que no hay variacin o dispersin de datos',...
                 '  la varianza es 0.',...
                 ' ',...
                 '   Se expresa la media muestral en notacin de punto flotante decimal',...
                ['  con ' num2str(t) ' dgitos de precisin.']);
          set(NIPtexto,'String',expl);
       elseif n > 1,        
          %Activacin del botn 'Mtodo de 1 paso'
          if strcmp(metodo,'unpaso'),
             sumadecuadrados = guardar(0,t);
             sumadedatos = guardar(0,t);
             for i = 1:n
                 d = guardar(x(i),t);
                 d_al2 = op_flot(d,d,'*');
                 sumadecuadrados = op_flot(sumadecuadrados,d_al2,'+');
                 sumadedatos = op_flot(sumadedatos,d,'+');
             end
             ene = guardar(n,t);
             media = op_flot(sumadedatos,ene,'/');
             m = op_flot(media,media,'*');
             term = op_flot(ene,m,'*');
             v = op_flot(sumadecuadrados,term,'-');
             ene = op_flot(ene,uno,'-');
             varianza = op_flot(v,ene,'/');
             acetato(' La media muestral de los datos',[' es x = ' notacion(media) '.'],' La varianza muestral de los mismos',[' es s^2 = ' notacion(varianza) '.'],'',' El mtodo de 1 paso utiliza la frmula','   s^2 = ( \Sigma_{i=1}^n x_i^2 - nx^2 ) /n-1');
             expl = str2mat( ...
                  '   Se expresa la media y varianza muestral en notacin de punto flotante',...
                 ['  decimal con ' num2str(t) ' dgitos de precisin.'],...
                  ' ',...
                 ['  Valor exacto de la media muestral: ' sprintf('%.9g',mean(x))],...
                 ['  Valor exacto de la varianza muestral: ' sprintf('%.9g',(std(x))^2)]);
             set(NIPtexto,'String',expl);
                       
          %Activacin del botn 'Mtodo de 2 pasos'
          elseif strcmp(metodo,'dospasos'),
             suma = guardar(0,t);
             v = guardar(0,t);
             for i = 1:n
                 dato = guardar(x(i),t);
                 suma = op_flot(suma,dato,'+');
             end
             ene = guardar(n,t);
             media = op_flot(suma,ene,'/');
             for j = 1:n
                 dato = guardar(x(j),t);
                 term = op_flot(dato,media,'-');
                 term = op_flot(term,term,'*');
                 v = op_flot(v,term,'+');
             end
             ene = op_flot(ene,uno,'-');
             varianza = op_flot(v,ene,'/');
             acetato(' La media muestral de los datos',[' es x = ' notacion(media) '.'],' La varianza muestral de los mismos',[' es s^2 = ' notacion(varianza) '.'],'',' El mtodo de 2 pasos utiliza la frmula','   s^2 = \Sigma_{i=1}^n (x_i - x)^2 /n-1');
             expl = str2mat( ...
                  '   Se expresa la media y varianza muestral en notacin de punto flotante',...
                 ['  decimal con ' num2str(t) ' dgitos de precisin.'],...
                  ' ',...
                 ['  Valor exacto de la media muestral: ' sprintf('%.9g',mean(x))],...
                 ['  Valor exacto de la varianza muestral: ' sprintf('%.9g',(std(x))^2)]);
             set(NIPtexto,'String',expl);
          end %if strcmp(metodo,...)
       end %if n == 0 
   end %if isempty...    
   
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' MEDIA Y VARIANZA MUESTRALES',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' Si se tienen los datos {\it x}_{1},{\it x}_{2},...,{\it x}_{n} la varianza muestral s^2',...
      'puede obtenerse mediante la expresin',...
      '                      s^2 = ( \Sigma_{i=1}^n {\it x}_i^2 - nx^2 ) /n-1',...
      'que se conoce como {\it mtodo de 1 paso}. La desventaja de esta',...
      'frmula es que al pogramarse en la computadora es muy susceptible',...
      'a la cancelacin numrica pues calcula la varianza muestral como',...
      'la diferencia de dos nmeros positivos.',...
      ' Una forma alternativa de calcular la varianza es',...
      '                      s^2 = \Sigma_{i=1}^n ({\it x}_i - x)^2 /n-1 ',...
      'la cual se conoce como {\it mtodo de 2 pasos}. Esta frmula',...
      'requiere leer dos veces los datos, lo que la hace inapropiada',...
      'para conjuntos muy grandes de datos, aunque como algoritmo',...
      'numrico es mejor que el primer mtodo.',...
      ' ',...
      ' Si desea escribir sus propios datos, borre en la ventana anterior',...
      'los valores actuales y escriba dentro de los corchetes sus nmeros',...
      'separados por un espacio.','',...
      'Programa fuente: medyvar.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
   
end %if strcmp(entrada,...)
