 function v = guardar(x,t)
 %GUARDAR Simula el guardar un n\'umero dado en una palabra cuya longitud
 %especifica el usuario.
 % De entrada:
 %  x es un nmero real.
 %  t es un valor entero entre 1 y 16 con el que se especifica el nmero 
 %    de dgitos de precisin para representar a x.
 %
 % Resultado:
 %  v es un vector rengln que simula una palabra de longitud t+1. En los 
 %  lugares 1 a t se guarda la mantisa y en el lugar t+1 el exponente.             
 %
 % Funcin implementada por Fernando Saldaa Jimnez, basada en represent.m
 % (Introduction to Scientific Computing: A Matrix-Vector Approach 
 % Charles F. Van Loan)
 % Ultima fecha de modificacin: 30 noviembre 2000

  if t < 0
    error('t no es entero positivo')
  end
                   
  if isreal(x)
     if x == 0
        v = zeros(1,t+1);  
     elseif abs(x) == inf
        v = x;  
     else         
     %Se determina la mantisa m y el exponente e de modo que 
     %    .1 <= m < 1         y         abs(x) = m*10^e       
        m = abs(x);  
        e = 0;
        while m >= 1        
              m = m/10; 
              e = e+1;
        end      
        while m < 1/10
              m = 10*m; 
              e = e-1;
        end      
     %Se determina el entero ms cercano a m*10^t 
        z = round((10^t)*m);	  
     %Se colocan las t cifras de la mantisa y el valor del 
     %exponente en los t+1 lugares del vector v  
        if z == 10^t         
           v(1) = 1; 
           v(t+1) = e+1;
        else
           sum = 0;
           for k = 1:t
               v(k) = floor((z-sum)/10^(t-k));
               sum = sum + v(k)*10^(t-k);
           end   
           v(t+1) = e;
        end      
     %Se considera el caso en que x pueda ser negativo
        if x < 0         
           v(1) = -v(1);
        end	  
     %Asignacin de valores en v cuando el exponente est 
     %fuera del rango [-308,308].      
        if e > 308
           v(t+1) = inf;
        elseif e < -308         
           v = zeros(1,t+1);
        end 
     end %if x == 0
  else  error('x no es un nmero real');
  end     
      