function ec2gr2(entrada);
%EC2GR2 resuelve la ecuacin de segundo grado
% x^2 - 4 + 3.9999999 = 0
%
% Funcin creada por Fernando Saldaa jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' RESOLUCION DE LA ECUACION DE SEGUNDO GRADO',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .59]);
      
   %Comentarios de inicio
   indica = str2mat( ...
       '   Para calcular las races de la ecuacin arriba escrita haga click con el ratn',...
       '  en alguno de los botones del tablero ''Solucin por'' segn el mtodo que elija.',...
       ' ',...
       '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
       '  longitud de mantisa. Enseguida vuelva a utilizar los botones mencionados.',...
       ' ',...
       '   Para apreciar grficamente las races oprima el botn ''Grficos''.');
   
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .34],...
             'BackgroundColor',[0 .8 0]);
   
   %El campo de comentarios y explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .25],...
                        'Callback','ec2gr2(''eval'');',...
                        'String',indica);
      
   %Los campos editables para que el usuario proporcione sus propios nmeros.
   %Inicialmente hay valores dados, los que constituyen el ejemplo.       
   dato1 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.06 .31 .16 .05],'String','1',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','right');
   dato2 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.29 .31 .16 .05],'String','-4',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','right');        
   dato3 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.52 .31 .16 .05],'String','3.9999999',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','right');
                  
   %Los rtulos 'x^2 +','x +' y '= 0'
   uicontrol('Style','text','Units','normalized',...
             'Position',[.22 .31 .06 .05],'String','x^2 +',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.45 .31 .06 .05],'String','x +',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.68 .31 .06 .05],'String','= 0',...
             'Backgroundcolor',[0 .8 0]);
     
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR'
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Ecuaciones de 2o. grado','Callback','ec2grado;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %El tablero de botones
   uicontrol('Style','frame','Units','normalized', ...
             'Position',[.79 .7 .18 .24],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
            'Position',[.8 .88 .16 .04],...
            'BackgroundColor',[.6 .8 1],...
            'ForegroundColor',[0 0 0],...
            'String','Solucin por');
       
   %Botn 'Frmula general'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .8 .16 .06],...
             'String','Frmula gral.',...
             'Callback','ec2gr2(''ejecuta'');',...
             'UserData','gral');
   
   %Botn 'Mtodo de Vieta'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .72 .16 .06],...
             'String','Mtdo. de Vieta',...
             'Callback','ec2gr2(''ejecuta'');',...
             'UserData','vieta');
   
   %Botn 'Grficos'
   uicontrol('Style','pushbutton','Units','normalized', ...
             'Position',[.8 .62 .16 .06],...
             'String','Grficos',...
             'Callback','ec2gr2(''ejecuta'');',...
             'UserData','grf');
    
   %Men 'Precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .56 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .57 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .49 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','ec2gr2(''ejecuta'');',...
                    'Value',8);
       
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','ec2gr2(''info'');');
    
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Se guardan los campos editables, el cuadro de explicaciones y el men 'precisin'
   %pues se requerirn en la siguiente parte del programa. 
   cambios = [dato1 dato2 dato3 NIPtexto prec];
   set(gcf,'UserData',cambios);
   
elseif strcmp(entrada,'ejecuta'),
   
   %Se traen los objetos grficos salvados con anterioridad   
   cambios = get(gcf,'UserData');
   dato1 = cambios(1);
   dato2 = cambios(2);
   dato3 = cambios(3);
   NIPtexto = cambios(4);
   prec = cambios(5);
   metodo = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Obtencin de los nmeros introducidos por el usuario   
   if ~isempty(get(dato1,'String')) & ~isempty(get(dato2,'String')) & ~isempty(get(dato3,'String')),   
      coef_a = eval(get(dato1,'String'));
      coef_b = eval(get(dato2,'String'));
      coef_c = eval(get(dato3,'String'));
      
      %Se simula el guardar los coeficientes de la ecuacin de 2o. grado en representacin
      %interna de una computadora que trabaja en base 10.
      a = guardar(coef_a,t); b = guardar(coef_b,t); c = guardar(coef_c,t); 
      dos_a = op_flot(guardar(2,t),a,'*');
      
      %Discriminante d = b^2-4ac.
      d = op_flot(op_flot(b,b,'*'),op_flot(op_flot(guardar(4,t),a,'*'),c,'*'),'-'); 
       
      if coef_a == 0 & coef_b == 0 & coef_c == 0,
         acetato(' OBSERVACION:','La ecuacin 0x^2 + 0x + 0 = 0','tiene una infinidad de soluciones.');
         expl = str2mat( ...
              '   Puesto que a = b = c = 0  no es posible aplicar la frmula general ni',...
              '  el mtodo de Vieta pues se llega a la operacin 0/0.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
                  
      elseif coef_a == 0 & coef_b == 0 & coef_c ~= 0,
         acetato(' OBSERVACION:',['La ecuacin 0x^2 + 0x + (' sprintf('%.9g',coef_c) ') = 0'],'no tiene solucin.');
         expl = str2mat( ...
              '   Puesto que a = b = 0  no es posible aplicar la frmula general ni',...
              '  el mtodo de Vieta pues se llega a la operacin 0/0.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
            
      elseif coef_a == 0 & coef_b ~= 0 & coef_c ~= 0,
         x = (-1)*valornum(op_flot(c,b,'/'));         %x = -c/b
         x = guardar(x,t);                             
         acetato(' OBSERVACION:',['La ecuacin 0x^2 + (' sprintf('%.9g',coef_b) ')x + (' sprintf('%.9g',coef_c) ') = 0'],'no es cuadrtica sino lineal y su solucin es',[' x = -c/b = ' notacion(x)]);
         expl = str2mat( ...                             
              '   Puesto que a = 0, NO se tiene una ecuacin de 2o. grado.',...
              ' ',...                                          
              '   Se muestra la solucin de la ecuacin lineal en notacin de punto flotante',...
             ['  decimal con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);                  
                                                     
      else 
         %Activacin del botn 'Frmula Gral.'
         if strcmp(metodo,'gral'),
            if coef_a ~= 0 & coef_b ~= 0 & coef_c == 0,
               x1 = guardar(0,t);                           %Una raz es 0.
               x2 = (-1)*valornum(op_flot(b,a,'/'));        %x2 = -b/a
               x2 = guardar(x2,t);
               acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 + (' sprintf('%.9g',coef_b) ')x = 0 tiene las races reales'],[' x1 = ' notacion(x1)],[' x2 = ' notacion(x2)],'','Las races reales x1 \neq x2 de la ecuacin ax^2 + bx + c = 0','deben cumplir:  x1 + x2 = -b/a    y    x1*x2 = c/a',[' x1 + x2 = ' notacion(op_flot(x1,x2,'+'))],[' x1*x2 = ' notacion(op_flot(x1,x2,'*'))]);
               expl = str2mat( ...
                    '   Puesto que c = 0 en la ecuacin cuadrtica, se ha aplicado la factorizacin',...
                    '  x(ax + b) = 0 para encontrar las races.',...
                    ' ',...
                    '   Las races x1 y x2 as como su suma y producto se muestran en notacin',...
                   ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                    ' ',...
                    '   Observe si se reconstruyen los coeficiente -b/a y c/a mediante la suma',...
                    '  y producto de las races respectivamente.');
               set(NIPtexto,'String',expl);
                           
            elseif coef_a ~= 0 & coef_b == 0 & coef_c == 0,
               x1 = guardar(0,t);
               acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 = 0  tiene las races repetidas:'],[' x1 = x2 = ' notacion(x1)]);
               expl = str2mat( ...
                    '   Esta es la ecuacin de una parbola cuyo vrtice se encuentra en el orgen',...
                    '  del plano cartesiano. Las races x1 = x2 se muestran en notacin de punto',...
                   ['  flotante decimal con ' num2str(t) ' dgitos de precisin.']);
               set(NIPtexto,'String',expl);
               
            else
               if valornum(d) < 0,
                  %Clculo de la parte imaginaria de la raz: sqrt(d)/2a
                  im = (-1)*valornum(d);
                  im = sqrt(im)/valornum(dos_a);
                  im = guardar(im,t);
                  %Clculo de la parte real de la raz: -b/2a
                  re = (-1)*valornum(op_flot(b,dos_a,'/'));
                  re = guardar(re,t);
                  acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 + (' sprintf('%.9g',coef_b) ')x + (' sprintf('%.9g',coef_c) ') = 0'],'tiene races imaginarias:',[' x1 = ' notacion(re) ' + ' notacion(im) 'i'],[' x2 = ' notacion(re) ' - ' notacion(im) 'i']);
                  expl = str2mat( ...
                       '   Se ha aplicado la frmula general encontrando como races nmeros complejos.',...
                       ' ',...
                       '   La parte real e imaginaria de x1 y x2 se muestran en notacin',...
                      ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.']);
                  set(NIPtexto,'String',expl);
                           
               else
                  d = guardar(sqrt(valornum(d)),t);
                  if valornum(b) > 0,
                     %x1 = -b-d/2a, x2 = -b+d/2a
                     x1 = (-1)*valornum(op_flot(op_flot(b,d,'+'),dos_a,'/'));
                     x2 = (-1)*valornum(op_flot(op_flot(b,d,'-'),dos_a,'/'));
                     x1 = guardar(x1,t); 
                     x2 = guardar(x2,t);
                  else 
                     %x1 = -b+d/2a, x2 = -b-d/2a
                     x1 = (-1)*valornum(op_flot(op_flot(b,d,'-'),dos_a,'/'));
                     x2 = (-1)*valornum(op_flot(op_flot(b,d,'+'),dos_a,'/'));
                     x1 = guardar(x1,t); 
                     x2 = guardar(x2,t);
                  end
                  acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 + (' sprintf('%.9g',coef_b) ')x + (' sprintf('%.9g',coef_c) ') = 0'],'tiene las races reales:',[' x1 = ' notacion(x1)],[' x2 = ' notacion(x2)],'','Las races reales x1, x2 de la ecuacin ax^2 + bx + c = 0','deben cumplir:  x1 + x2 = -b/a    y    x1*x2 = c/a',[' x1 + x2 = ' notacion(op_flot(x1,x2,'+'))],[' x1*x2 = ' notacion(op_flot(x1,x2,'*'))]);
                  expl = str2mat( ...
                       '   Se ha aplicado la frmula general encontrando las races x1,x2 las cuales',...
                      ['  se muestran en notacin de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                       ' ',...
                       '   Observe si se reconstruyen los coeficientes -b/a y c/a mediante la suma',...
                       '  y el producto de las races respectivamente.');
                  set(NIPtexto,'String',expl);
               end %if valornum(d)...
            end %if coef_a ~= 0 & coef_b ~= 0 & coef_c == 0   
            
         %Activacin del botn 'Mtdo. de Vieta'    
         elseif strcmp(metodo,'vieta'),
            if coef_a ~= 0 & coef_b ~= 0 & coef_c == 0,
              x1 = guardar(0,t);                           %Una raz es 0.
              x2 = (-1)*valornum(op_flot(b,a,'/'));        %x2 = -b/a
              x2 = guardar(x2,t);
              acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 + (' sprintf('%.9g',coef_b) ')x = 0 tiene las races reales'],[' x1 = ' notacion(x1)],[' x2 = ' notacion(x2)],'','Las races reales x1 \neq x2 de la ecuacin ax^2 + bx + c = 0','deben cumplir:  x1 + x2 = -b/a    y    x1*x2 = c/a',[' x1 + x2 = ' notacion(op_flot(x1,x2,'+'))],[' x1*x2 = ' notacion(op_flot(x1,x2,'*'))]);
              expl = str2mat( ...
                   '   Puesto que c = 0 en la ecuacin cuadrtica, se ha aplicado la factorizacin',...
                   '  x(ax + b) = 0 para encontrar las races.',...
                   ' ',...
                   '   Las races x1 y x2 as como su suma y producto se muestran en notacin',...
                  ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                   ' ',...
                   '   Observe si se reconstruyen los coeficiente -b/a y c/a mediante la suma',...
                   '  y producto de las races respectivamente.');
              set(NIPtexto,'String',expl);
                           
            elseif coef_a ~= 0 & coef_b == 0 & coef_c == 0,
              x1 = guardar(0,t);
              acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 = 0  tiene las races repetidas:'],[' x1 = x2 = ' notacion(x1)]);
              expl = str2mat( ...
                   '   Esta es la ecuacin de una parbola cuyo vrtice se encuentra en el orgen',...
                   '  del plano cartesiano. Las races x1 = x2 se muestran en notacin de punto',...
                  ['  flotante decimal con ' num2str(t) ' dgitos de precisin.']);
              set(NIPtexto,'String',expl);
               
            else
              if valornum(d) < 0,
                 %Clculo de la parte imaginaria de la raz: sqrt(d)/2a
                 im = (-1)*valornum(d);
                 im = sqrt(im)/valornum(dos_a);
                 im = guardar(im,t);
                 %Clculo de la parte real de la raz: -b/2a
                 re = (-1)*valornum(op_flot(b,dos_a,'/'));
                 re = guardar(re,t);
                 acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 + (' sprintf('%.9g',coef_b) ')x + (' sprintf('%.9g',coef_c) ') = 0'],'tiene races imaginarias:',[' x1 = ' notacion(re) ' + ' notacion(im) 'i'],[' x2 = ' notacion(re) ' - ' notacion(im) 'i']);
                 expl = str2mat( ...
                      '   La parte real e imaginaria de x1 y x2 se muestran en notacin',...
                     ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.']);
                 set(NIPtexto,'String',expl);
                         
              else
                 d = guardar(sqrt(valornum(d)),t);
                 if valornum(b) > 0,
                   %x1 = -b-d/2a
                   x1 = (-1)*valornum(op_flot(op_flot(b,d,'+'),dos_a,'/'));
                   x1 = guardar(x1,t);
                   %x2 = c/a*x1
                   x2 = op_flot(c,op_flot(a,x1,'*'),'/');
                 else
                   %x1 = -b+d/2a
                   x1 = (-1)*valornum(op_flot(op_flot(b,d,'-'),dos_a,'/'));
                   x1 = guardar(x1,t);
                   %x2 = c/a*x1
                   x2 = op_flot(c,op_flot(a,x1,'*'),'/');
                 end   
                 acetato(['La ecuacin ' sprintf('%.9g',coef_a) 'x^2 + (' sprintf('%.9g',coef_b) ')x + (' sprintf('%.9g',coef_c) ') = 0'],'tiene las races reales:',[' x1 = ' notacion(x1)],[' x2 = ' notacion(x2)],'','Las races reales x1, x2 de la ecuacin ax^2 + bx + c = 0','deben cumplir:  x1 + x2 = -b/a    y    x1*x2 = c/a',[' x1 + x2 = ' notacion(op_flot(x1,x2,'+'))],[' x1*x2 = ' notacion(op_flot(x1,x2,'*'))]);
                 expl = str2mat( ...
                      '   Se ha aplicado el mtodo de Vieta encontrando las races x1,x2 las cuales',...
                     ['  se muestran en notacin de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                      ' ',...
                      '   Observe si se reconstruyen los coeficientes -b/a y c/a mediante la suma',...
                      '  y el producto de las races respectivamente.');
                 set(NIPtexto,'String',expl);
              end %if valornum(d)...
            end %if coef_a ~= 0 & coef_b ~= 0 & coef_c == 0
          
         %Activacin del botn 'Grfico'
         elseif strcmp(metodo,'grf'),
            figNumber = figure('Units','normalized','Name',' G R A F I C O S',...
             'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
            
            %Clculo de races exactas con la funcin roots de Matlab
            p = [coef_a coef_b coef_c];
            raiz = sort(roots(p));
            %Instrucciones para el graficado de las races
            a0 = raiz(1)-2; af = raiz(1)+2; b0 = raiz(2)-2; bf = raiz(2)+2;
            x_1 = a0:0.1:af;
            x_2 = b0:0.1:bf;
            y1 = p(1) .*x_1.^2 + p(2) .*x_1 + p(3);
            y2 = p(1) .*x_2.^2 + p(2) .*x_2 + p(3);
                     
            %Grfico de raz del lado izquierdo
            subplot(1,2,1); plot(x_1,y1,'r',x_1,zeros(1,length(x_1)),raiz(1),0,'ok'); 
            axis([a0 af -2 2]); grid on; axis square;
            text(a0 + .05,-0.6,'raz:','Fontsize',8);
            text(a0 + .05,-0.8,[' x = ' sprintf('%.9g',raiz(1))],'Fontsize',8);
               
            %Grfico de raz del lado derecho
            subplot(1,2,2); plot(x_2,y2,'r',x_2,zeros(1,length(x_2)),raiz(2),0,'ok'); 
            axis([b0 bf -2 2]); grid on; axis square;
            text(b0 + .05,-0.6,'raz:','Fontsize',8);
            text(b0 + .05,-0.8,[' x = ' sprintf('%.9g',raiz(2))],'Fontsize',8);
             
            %Identificacin de la parbola
            axes('Parent',figNumber,'Units','normalized','Visible','on','Position',[.1 .8 .8 .1]);
            acetato('','',['Races de la parbola  ' sprintf('%.9g',p(1)) 'x^2 + (' sprintf('%.9g',p(2)) ')x + (' sprintf('%.9g',p(3)) ')']);
             
            %Cuadro de explicaciones
            expl = str2mat( ...
                 '   Se muestran los segmentos de la parbola (rojo) donde sta es cortada',...
                 '  por el eje de las abscisas (azul).',...
                 ' ',...
                 '   El smbolo ''o'' indica grficamente las races de la parbola.');
            uicontrol('Style','frame','Units','normalized',...
                      'Position',[.01 .01 .74 .2],...
                      'BackgroundColor',[0 .7 0]);
            uicontrol('Style','text','Units','normalized',...
                      'HorizontalAlignment','left',...
                      'Max',5,...
                      'BackgroundColor',[1 1 1],...
                      'Position',[.02 .02 .72 .18],...
                      'String',expl);
                   
            %Consola y botn 'Cerrar'                
            uicontrol('Style','frame','Units','normalized',...
                      'Position',[.78 .03 .2 .1],...
                      'BackgroundColor',[0 .7 0]);
            uicontrol('Style','push','Units','normalized',...
                      'Position',[.8 .05 .16 .06],...
                      'String','C e r r a r',...
                      'Callback','close(gcf)');
                        
         end %if strcmp(metodo,...)
      end %if coef_a == 0 & coef_b == 0 & coef_c == 0         
   else
      errordlg('Introduzca sus nmeros antes de usar los botones y/o el men ''Precisin''','E R R O R');
   end %if ~isempty(get(dato1,'String')) & ...
   
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' RESOLUCION DE LA ECUACION DE SEGUNDO GRADO',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' La ecuacin {\it x}^{2}-4{\it x}+3.9999999 = 0 tiene como races exactas',...
      '                    {\it x}_{1} = 2.000316227...',...
      '                    {\it x}_{2} = 1.999683772...',...
      'pero cuando dicha ecuacin es resuelta en la computadora aplicando',...
      'la frmula general',...
      '                {\it x} = -{\it b} \pm ({\it b}^{2}-4{\it ac})^{1/2} / 2{\it a}',...
      'con {\it a} = 1, {\it b} = -4, {\it c} = 3.9999999, puesto que {\it b}^{2} \approx |4{\it ac}|' ,...
      'al trabajar en aritmtica de punto flotante con precisin',...
      '{\it t} \leq 8 dgitos el radicando {\it b}^{2}-4{\it ac} sufre cancelacin numrica',...
      'dando como resultado las races repetidas {\it x}_{1} = {\it x}_{2} = 2.',...
      ' ',...
      ' Lo mismo sucede al utilizar el {\it mtodo de Vieta} ya que en su',...
      'primer etapa aplica la frmula general. Dicho mtodo evita',...
      'la resta entre -{\it b} y ({\it b}^{2}-4{\it ac})^{1/2} pero no la sustraccin que hay',...
      'dentro de este ltimo radical.',...
      ' ',...
      ' ',...
      ' ',...
      'Programa fuente: ec2gr2.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
   
end %if strcmp(entrada,...)