function cramer(entrada);
%CRAMER resuelve un sistema 2x2 mediante la Regla de Cramer
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' REGLA DE CRAMER',...
   'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   ejes = axes('Units','normalized','Visible','off','Position',[.05 .45 .7 .52]);
      
   %Comentarios de inicio
   indica = str2mat('   Oprima el botn ''Solucin'' para resolver el sistema y encontrar los residuales de',...
    '  dicha solucin.',...
    ' ',...
    '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
    '  longitud de mantisa. Enseguida vuelva a utilizar el botn ''Solucin''.',...
    ' ',...
    '   Para ver las rectas que dibujan este sistema oprima el botn ''Grfico''.');
   
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .4],...
             'BackgroundColor',[0 .8 0]);
     
   %El campo de explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .24],...
                        'Callback','cramer(''eval'');',...
                        'String',indica);
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   %Men 'REGRESAR' a mdulos anteriores del Taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Sistemas Lineales','Callback','sistemas;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
   %Men 'RESOLVER'  
   metodo = uimenu(figNumber,'Label','RESOLVER POR');
   piv_p = uimenu(metodo,'Label','E G c P P','Callback','cramer(''egcp'');');
   s_piv = uimenu(metodo,'Label','E G s P','Callback','cramer(''eg'');');
   
   %Valores que proporcionar el usuario. Inicialmente hay valores dados.
   coefA11 = uicontrol('Style','edit','Units','normalized','Position',[.05 .37 .18 .05],...
                       'String','0.373','HorizontalAlignment','right',...
                       'Backgroundcolor','w');
   coefA12 = uicontrol('Style','edit','Units','normalized','Position',[.31 .37 .18 .05],...
                       'String','0.296','HorizontalAlignment','right',...
                       'Backgroundcolor','w');
   coefA21 = uicontrol('Style','edit','Units','normalized','Position',[.05 .3 .18 .05],...
                       'String','0.326','HorizontalAlignment','right',...
                       'Backgroundcolor','w');
   coefA22 = uicontrol('Style','edit','Units','normalized','Position',[.31 .3 .18 .05],...
                       'String','0.260','HorizontalAlignment','right',...
                       'Backgroundcolor','w');
   coefB1 = uicontrol('Style','edit','Units','normalized','Position',[.57 .37 .18 .05],...
                      'String','0.521','HorizontalAlignment','left',...
                      'Backgroundcolor','w');
   coefB2 = uicontrol('Style','edit','Units','normalized','Position',[.57 .3 .18 .05],...
                      'String','0.456','HorizontalAlignment','left',...
                      'Backgroundcolor','w');
              
   %Rtulos 'x +' y 'y ='
   uicontrol('Style','text','Units','normalized','String','x  +',...
             'Position',[.23 .37 .07 .05],'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized','String','y  =',...
             'Position',[.49 .37 .07 .05],'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized','String','x  +',...
             'Position',[.23 .3 .07 .05],'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized','String','y  =',...
             'Position',[.49 .3 .07 .05],'Backgroundcolor',[0 .8 0]);
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn 'Solucin'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .86 .16 .06],...
             'String','Solucin',...
             'Callback','cramer(''ejecuta'');',...
             'UserData','sln');
   
   %Botn 'Grfico'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .78 .16 .06],...
             'String','Grfico',...
             'Callback','cramer(''ejecuta'');',...
             'UserData','grf');
     
   %Men 'Precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .68 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .69 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .61 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','cramer(''ejecuta'');',...
                    'Value',4);
       
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','cramer(''info'');');
   
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Guardar el cuadro de explicaciones, el men 'Precisin' y los ejes 
   cambios = [coefA11 coefA12 coefA21 coefA22 coefB1 coefB2 NIPtexto prec ejes];
   set(gcf,'UserData',cambios);
   
elseif strcmp(entrada,'ejecuta'), 
   
   %Se traen los objetos grficos salvados con anterioridad  
   cambios = get(gcf,'UserData');
   coefA11 = cambios(1);
   coefA12 = cambios(2);
   coefA21 = cambios(3);
   coefA22 = cambios(4);
   coefB1 = cambios(5);
   coefB2 = cambios(6);
   NIPtexto = cambios(7);
   prec = cambios(8);
   ejes = cambios(9);
   accion = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Se traen los valores de los campos editables
   if ~isempty(get(coefA11,'String')) & ~isempty(get(coefA12,'String')) & ~isempty(get(coefA21,'String')) & ~isempty(get(coefA22,'String')) & ~isempty(get(coefB1,'String'))& ~isempty(get(coefB2,'String')),
      A = []; b = zeros(2,1);
      A(1,1) = eval(get(coefA11,'String'));
      A(1,2) = eval(get(coefA12,'String'));
      A(2,1) = eval(get(coefA21,'String'));
      A(2,2) = eval(get(coefA22,'String'));
      b(1) = eval(get(coefB1,'String'));
      b(2) = eval(get(coefB2,'String'));   
      %El caso en que A = 0  y  b = 0
      if isequal(A,zeros(2,2)) & isequal(b,zeros(2,1)), 
         set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
         acetato(' OBSERVACION: El sistema','    0x + 0y = 0','    0x + 0y = 0',' tiene una infinidad de soluciones.');
         expl = str2mat('   En ambas ecuaciones proporcione por lo menos coeficientes de x  y  y',...
              '  diferentes de 0.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
         
      %El caso en que A = 0  y  b ~= 0   
      elseif isequal(A,zeros(2,2)) & ~isequal(b,zeros(2,1)), 
         set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
         acetato(' OBSERVACION: El sistema',['    0x + 0y = ' sprintf('%.9g',b(1))],['    0x + 0y = ' sprintf('%.9g',b(2))],' NO tiene solucin.');
         expl = str2mat('   Proporcione coeficientes de x y y diferentes de 0 en ambas ecuaciones.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
         
      else
         %Activacin del botn 'Solucin'
         if strcmp(accion,'sln'),
            if A(1,2) ~= 0 & A(2,2) ~= 0,
               %Se considera el caso de un sistema compatible dependiente
               if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
                  set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                  acetato(' OBSERVACION: El sistema',['    (' sprintf('%.9g',A(1,1)) ')x + (' sprintf('%.9g',A(1,2)) ')y = ' sprintf('%.9g',b(1))],['    (' sprintf('%.9g',A(2,1)) ')x + (' sprintf('%.9g',A(2,2)) ')y = ' sprintf('%.9g',b(2))],' es dependiente y tiene una infinidad de soluciones.');
                  expl = str2mat(['   La segunda ecuacin se obtiene al multiplicar por ' sprintf('%.5g',(A(2,2)/A(1,2)))],...
                       '  la primer ecuacin.',...
                       ' ',...
                      ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
                  set(NIPtexto,'String',expl);
                  
               %Se considera el caso de un sistema incompatible   
               elseif (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) ~= (b(2)/A(2,2)),
                  set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                  acetato(' OBSERVACION: El sistema',['    (' sprintf('%.9g',A(1,1)) ')x + (' sprintf('%.9g',A(1,2)) ')y = ' sprintf('%.9g',b(1))],['    (' sprintf('%.9g',A(2,1)) ')x + (' sprintf('%.9g',A(2,2)) ')y = ' sprintf('%.9g',b(2))],' NO tiene solucin.');
                  expl = str2mat('   Las ecuaciones forman un sistema incompatible.',...
                       ' ',...
                       ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']); 
                  set(NIPtexto,'String',expl);  
                  
               %El caso del sistema concurrente   
               else
                  %Se simula el guardar los coeficientes del sistema en representacin
                  %interna de una computadora que trabaja en base 10.
                  a11 = guardar(A(1,1),t); a12 = guardar(A(1,2),t); b1 = guardar(b(1),t);
                  a21 = guardar(A(2,1),t); a22 = guardar(A(2,2),t); b2 = guardar(b(2),t);
                      
                  %Aplicacin de la regla de Cramer.
                  %Determinante del sistema
                  D = op_flot(op_flot(a11,a22,'*'),op_flot(a21,a12,'*'),'-');
                    
                  %Determinante numerador de la solucin x
                  Dx = op_flot(op_flot(b1,a22,'*'),op_flot(b2,a12,'*'),'-');
                       
                  %Determinante numerador de la solucin y
                  Dy = op_flot(op_flot(a11,b2,'*'),op_flot(a21,b1,'*'),'-');
                  %Solucin exacta del sistema
                  s = A\b;
                    
                  if valornum(D) == 0,
                     set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                     acetato(' OBSERVACION:','La matriz asociada a este sistema tiene determinante D = 0.','Los otros determinantes son:',['  Dx = ' notacion(Dx) ],['  Dy = ' notacion(Dy)],'','No es posible resolver el sistema por la Regla de Cramer:','                       (x,y) = (Dx/D,Dy/D)');
                     expl = str2mat( ...
                         ['   Al trabajar con precisin t = ' num2str(t) ' dgitos, la matriz'],...
                         ['           A = ' sprintf('%.7g',A(1,1)) '  ' sprintf('%.7g',A(1,2))],...
                         ['                 ' sprintf('%.7g',A(2,1)) '  ' sprintf('%.7g',A(2,2))],...
                          '  es singular. Si desea resolver este sistema por otro mtodo abra el men',...
                          '  ''RESOLVER POR'' localizado en la barra superior de mens.',...
                          ' ',...
                         ['   La solucin exacta del sistema es (x,y) = ('  sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                     set(NIPtexto,'String',expl);
                  else
                     %Solucin numrica
                     xc = op_flot(Dx,D,'/');  yc = op_flot(Dy,D,'/');
                      
                     %Clculo de residuales
                     r1 = A(1,1)*(valornum(xc)) + A(1,2)*(valornum(yc))- b(1);
                     r2 = A(2,1)*(valornum(xc)) + A(2,2)*(valornum(yc))- b(2);
                     r1 = guardar(r1,t);
                     r2 = guardar(r2,t);
                     set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                     acetato('La solucin del sistema mediante la Regla de Cramer es',['    x_c = ' notacion(xc)],['    y_c = ' notacion(yc)],'',['    r1 = ' sprintf('%.7g',A(1,1)) 'x_c + ' sprintf('%.7g',A(1,2)) 'y_c - ' sprintf('%.7g',b(1))],['       = ' notacion(r1)],'',['    r2 = ' sprintf('%.7g',A(2,1)) 'x_c + ' sprintf('%.7g',A(2,2)) 'y_c - ' sprintf('%.7g',b(2))],['       = ' notacion(r2)]); 
                     expl = str2mat('   Se muestra la solucin numrica as como los residuales r1 y r2 en notacin',...
                         ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                          ' ',...
                         ['   La solucin exacta del sistema es (x,y) = ('  sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')'],...
                          ' ',... 
                          '   Si desea resolver este sistema por otro mtodo abra el men ''RESOLVER POR''',...
                          '  localizado en la barra superior de mens.');
                     set(NIPtexto,'String',expl);
                  end %if valornum(D) == 0
               end %if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
            end %if A(1,2) ~= 0 & A(2,2) ~= 0,
         %Activacin del botn 'Grfico'
         elseif strcmp(accion,'grf'),
             if A(1,2) ~= 0 & A(2,2) ~= 0,
               %Pendientes de las rectas
               m1 = -(A(1,1)/A(1,2)); m2 = -(A(2,1)/A(2,2));
               set(ejes,'Visible','on','Position',[.05 .48 .7 .49]);  
               %Se considera el caso de un sistema compatible dependiente
               if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
                  x = -10:0.5:10;
                  %recta de la ecuacin (1)
                  y1 = m1 .*x + (b(1)/A(1,2));
                  %recta de la ecuacin (2)
                  y2 = m2 .*x + (b(2)/A(2,2));
                  plot(x,y1,'-r',x,y2,'-b'); grid on; axis([-10 10 -10 10]); axis('square');
                  text(-9.5,-6.5,[ sprintf('%.9g',A(1,1)) 'x + ' sprintf('%.9g',A(1,2)) 'y = ' sprintf('%.9g',b(1))],'Color','r','Fontsize',9);
                  text(-9.5,-8.5,[ sprintf('%.9g',A(2,1)) 'x + ' sprintf('%.9g',A(2,2)) 'y = ' sprintf('%.9g',b(2))],'Color','b','Fontsize',9);
                  expl = str2mat('   Esta es la representacin grfica del sistema.',...
                       '  Se trata de dos rectas superpuestas, de modo que el sistema es compatible dependiente.');
                  set(NIPtexto,'String',expl);
                    
               %Se considera el caso de un sistema incompatible   
               elseif (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) ~= (b(2)/A(2,2)),
                  x = -10:0.5:10;
                  %recta de la ecuacin (1)
                  y1 = m1 .*x + (b(1)/A(1,2));
                  %recta de la ecuacin (2)
                  y2 = m2 .*x + (b(2)/A(2,2));
                  plot(x,y1,'-r',x,y2,'-b'); grid on; axis([-10 10 -10 10]); axis('square');
                  text(-9.5,-6.5,[ sprintf('%.9g',A(1,1)) 'x + ' sprintf('%.9g',A(1,2)) 'y = ' sprintf('%.9g',b(1))],'Color','r','Fontsize',9);
                  text(-9.5,-8.5,[ sprintf('%.9g',A(2,1)) 'x + ' sprintf('%.9g',A(2,2)) 'y = ' sprintf('%.9g',b(2))],'Color','b','Fontsize',9);
                  expl = str2mat('   Esta es la representacin grfica del sistema.',...
                       '  Se trata de dos rectas paralelas, de modo que el sistema es incompatible.');
                  set(NIPtexto,'String',expl);
                  
               %El sistema concurrente   
               else
                  s = A\b;
                  a0 = s(1)- 1; af = s(1)+ 1; c0 = s(2)- 1; cf = s(2)+ 1; 
                  x = a0:0.05:af;
                  %recta de la ecuacin (1)
                  y1 = m1 .*x + (b(1)/A(1,2));
                  %recta de la ecuacin (2)
                  y2 = m2 .*x + (b(2)/A(2,2));
                  plot(x,y1,'-r',x,y2,'-b',s(1),s(2),'ok'); grid on; axis([a0 af c0 cf]); axis('square');
                  text(a0+0.1,c0+0.3,[ sprintf('%.7g',A(1,1)) 'x + ' sprintf('%.7g',A(1,2)) 'y = ' sprintf('%.7g',b(1))],'Color','r','Fontsize',9);
                  text(a0+0.1,c0+0.15,[ sprintf('%.7g',A(2,1)) 'x + ' sprintf('%.7g',A(2,2)) 'y = ' sprintf('%.7g',b(2))],'Color','b','Fontsize',9);
                        
                  if m1*m2 == -1,
                     expl = str2mat('   Esta es la representacin grfica del sistema. Las rectas son perpendiculares.',...
                          ' ',...
                          '   El smbolo ''o'' se sita en la interseccin de las lneas.',...
                          ' ',...
                         ['   La solucin exacta de este sistema es (x,y) = (' sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                     set(NIPtexto,'String',expl);
                  else
                     expl = str2mat('   Esta es la representacin grfica del sistema.',...
                          ' ',...
                          '   El smbolo ''o'' se sita en la interseccin de las rectas.',...
                          ' ',...
                         ['   La solucin exacta de este sistema es (x,y) = (' sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                     set(NIPtexto,'String',expl);
                  end %if m1*m2 == -1
               end %if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
            end %if A(1,2) ~= 0 & A(2,2) ~= 0,
         end %if strcmp(accion,...) 
      end %if isequal(A,zeros(2,2)) & isequal(b,zeros(2,1)),   
   else
      errordlg('Falta introducir algn o algunos coeficientes','E R R O R'); 
   end  %if ~isempty...
   
%Solucin mediante Eliminacin Gaussiana con Pivoteo Parcial    
elseif strcmp(entrada,'egcp'),
   %Se traen los objetos grficos salvados en cramer('iniciar')  
   cambios = get(gcf,'UserData');
   coefA11 = cambios(1);
   coefA12 = cambios(2);
   coefA21 = cambios(3);
   coefA22 = cambios(4);
   coefB1 = cambios(5);
   coefB2 = cambios(6);
   NIPtexto = cambios(7);
   prec = cambios(8);
   ejes = cambios(9);
   accion = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Se traen los valores de los campos editables
   if ~isempty(get(coefA11,'String')) & ~isempty(get(coefA12,'String')) & ~isempty(get(coefA21,'String')) & ~isempty(get(coefA22,'String')) & ~isempty(get(coefB1,'String'))& ~isempty(get(coefB2,'String')),
      A = []; b = zeros(2,1);
      A(1,1) = eval(get(coefA11,'String'));
      A(1,2) = eval(get(coefA12,'String'));
      A(2,1) = eval(get(coefA21,'String'));
      A(2,2) = eval(get(coefA22,'String'));
      b(1) = eval(get(coefB1,'String'));
      b(2) = eval(get(coefB2,'String'));
      
      %El caso en que A = 0  y  b = 0
      if isequal(A,zeros(2,2)) & isequal(b,zeros(2,1)), 
         set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
         acetato(' OBSERVACION: El sistema','    0x + 0y = 0','    0x + 0y = 0',' tiene una infinidad de soluciones.');
         expl = str2mat('   En ambas ecuaciones proporcione por lo menos coeficientes de x  y  y',...
              '  diferentes de 0.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
         
      %El caso en que A = 0  y  b ~= 0   
      elseif isequal(A,zeros(2,2)) & ~isequal(b,zeros(2,1)), 
         set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
         acetato(' OBSERVACION: El sistema',['    0x + 0y = ' sprintf('%.9g',b(1))],['    0x + 0y = ' sprintf('%.9g',b(2))],' NO tiene solucin.');
         expl = str2mat('   Proporcione coeficientes de x y y diferentes de 0 en ambas ecuaciones.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
         
      else
            %Proceso de solucin mediante EGPP    
            if A(1,2) ~= 0 & A(2,2) ~= 0,
               %Se considera el caso de un sistema compatible dependiente
               if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
                  set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                  acetato(' OBSERVACION: El sistema',['    (' sprintf('%.9g',A(1,1)) ')x + (' sprintf('%.9g',A(1,2)) ')y = ' sprintf('%.9g',b(1))],['    (' sprintf('%.9g',A(2,1)) ')x + (' sprintf('%.9g',A(2,2)) ')y = ' sprintf('%.9g',b(2))],' es dependiente y tiene una infinidad de soluciones.');
                  expl = str2mat(['   La segunda ecuacin se obtiene al multiplicar por ' sprintf('%.5g',(A(2,2)/A(1,2)))],...
                       '  la primer ecuacin.',...
                       ' ',...
                      ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
                  set(NIPtexto,'String',expl);
                  
               %Se considera el caso de un sistema incompatible   
               elseif (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) ~= (b(2)/A(2,2)),
                  set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                  acetato(' OBSERVACION: El sistema',['    (' sprintf('%.9g',A(1,1)) ')x + (' sprintf('%.9g',A(1,2)) ')y = ' sprintf('%.9g',b(1))],['    (' sprintf('%.9g',A(2,1)) ')x + (' sprintf('%.9g',A(2,2)) ')y = ' sprintf('%.9g',b(2))],' NO tiene solucin.');
                  expl = str2mat('   Las ecuaciones forman un sistema incompatible.',...
                       ' ',...
                       ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']); 
                  set(NIPtexto,'String',expl);  
                  
               %El caso del sistema concurrente   
               else
                  %Se simula el guardar los coeficientes del sistema en representacin interna
                  %de una computadora que trabaja en base 10.
                  a = guardar(A(1,1),t); e = guardar(A(1,2),t); f = guardar(b(1),t);
                  c = guardar(A(2,1),t); d = guardar(A(2,2),t); g = guardar(b(2),t);
                   
                  %Intercambio de renglones si es necesario
                  if abs(valornum(c)) > abs(valornum(a)),
                     a11 = c; a12 = d; b1 = g;
                     a21 = a; a22 = e; b2 = f;
                  elseif abs(valornum(a)) >= abs(valornum(c)),
                     a11 = a; a12 = e; b1 = f;
                     a21 = c; a22 = d; b2 = g;
                  end
                    
                  %Solucin exacta
                  s = A\b;
                          
                  if abs(valornum(a11)) == 0,
                     set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                     acetato(' OBSERVACION:',['La matriz  A = ' sprintf('%.7g',A(1,1)) '  ' sprintf('%.7g',A(1,2))],['                         ' sprintf('%.7g',A(2,1)) '  ' sprintf('%.7g',A(2,2))],'es singular.');
                     expl = str2mat( ...
                         ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
                     set(NIPtexto,'String',expl);
                  else
                     %mltiplo     
                     m = op_flot(a21,a11,'/');
                     %Obtencin de la matriz triangular superior
                     a21 = op_flot(a21,op_flot(m,a11,'*'),'-');  % <- debe ser 0
                     a22 = op_flot(a22,op_flot(m,a12,'*'),'-');
                     b2 = op_flot(b2,op_flot(m,b1,'*'),'-');
                     if abs(valornum(a22)) == 0,
                        set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                        acetato(' OBSERVACION:','Al efectuar E G c P P se ha obtenido un sistema','no sobredeterminado:',['  ' notacion(a11) '   ' notacion(a12) '   ' notacion(b1)],['  ' notacion(a21) '   ' notacion(a22) '   ' notacion(b2)],'',['La matriz  A = ' sprintf('%.7g',A(1,1)) '  ' sprintf('%.7g',A(1,2))],['                      ' sprintf('%.7g',A(2,1)) '  ' sprintf('%.7g',A(2,2))],'es cercana a ser singular.');
                        expl = str2mat( ...
                            ['   Al trabajar con precisin t = ' num2str(t) ' dgitos La matriz A  es singular.'],...
                             ' ',...
                            ['   La solucin exacta del sistema es (x,y) = ('  sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                        set(NIPtexto,'String',expl);
                     else
                        %Solucin del sistema (sustitucin hacia atrs)
                        yGp = op_flot(b2,a22,'/');
                        xGp = op_flot(op_flot(b1,op_flot(a12,yGp,'*'),'-'),a11,'/');
                                   
                        %Clculo de residuales
                        r1 = A(1,1)*(valornum(xGp)) + A(1,2)*(valornum(yGp))- b(1);
                        r2 = A(2,1)*(valornum(xGp)) + A(2,2)*(valornum(yGp))- b(2);
                        r1 = guardar(r1,t);
                        r2 = guardar(r2,t);
                        set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                        acetato('La solucin del sistema mediante E G c P P es',['    x_{Gp} = ' notacion(xGp)],['    y_{Gp} = ' notacion(yGp)],'',['    r1 = ' sprintf('%.7g',A(1,1)) 'x_{Gp} + ' sprintf('%.7g',A(1,2)) 'y_{Gp} - ' sprintf('%.7g',b(1))],['       = ' notacion(r1)],'',['    r2 = ' sprintf('%.7g',A(2,1)) 'x_{Gp} + ' sprintf('%.7g',A(2,2)) 'y_{Gp} - ' sprintf('%.7g',b(2))],['       = ' notacion(r2)]); 
                        expl = str2mat('   Se muestra la solucin numrica as como los residuales r1 y r2 en notacin',...
                            ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                             ' ',...
                            ['   La solucin exacta del sistema es (x,y) = ('  sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                        set(NIPtexto,'String',expl);
                     end %if abs(valornum(a22))...
                  end %if abs(valornum(a11))...
               end %if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
            end %if A(1,2) ~= 0 & A(2,2) ~= 0,
      end %if isequal(A,zeros(2,2)) & isequal(b,zeros(2,1)), 
   else
      errordlg('Falta introducir algn o algunos coeficientes','E R R O R'); 
   end  %if ~isempty...
   
%Solucin mediante Eliminacin Gaussiana Sin Pivoteo   
elseif strcmp(entrada,'eg')
   %Se traen los objetos grficos salvados en cramer('iniciar')  
   cambios = get(gcf,'UserData');
   coefA11 = cambios(1);
   coefA12 = cambios(2);
   coefA21 = cambios(3);
   coefA22 = cambios(4);
   coefB1 = cambios(5);
   coefB2 = cambios(6);
   NIPtexto = cambios(7);
   prec = cambios(8);
   ejes = cambios(9);
   accion = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Se traen los valores de los campos editables
   if ~isempty(get(coefA11,'String')) & ~isempty(get(coefA12,'String')) & ~isempty(get(coefA21,'String')) & ~isempty(get(coefA22,'String')) & ~isempty(get(coefB1,'String'))& ~isempty(get(coefB2,'String')),
      A = []; b = zeros(2,1);
      A(1,1) = eval(get(coefA11,'String'));
      A(1,2) = eval(get(coefA12,'String'));
      A(2,1) = eval(get(coefA21,'String'));
      A(2,2) = eval(get(coefA22,'String'));
      b(1) = eval(get(coefB1,'String'));
      b(2) = eval(get(coefB2,'String'));
      
      %El caso en que A = 0  y  b = 0
      if isequal(A,zeros(2,2)) & isequal(b,zeros(2,1)), 
         set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
         acetato(' OBSERVACION: El sistema','    0x + 0y = 0','    0x + 0y = 0',' tiene una infinidad de soluciones.');
         expl = str2mat('   En ambas ecuaciones proporcione por lo menos coeficientes de x  y  y',...
              '  diferentes de 0.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
         
      %El caso en que A = 0  y  b ~= 0   
      elseif isequal(A,zeros(2,2)) & ~isequal(b,zeros(2,1)), 
         set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
         acetato(' OBSERVACION: El sistema',['    0x + 0y = ' sprintf('%.9g',b(1))],['    0x + 0y = ' sprintf('%.9g',b(2))],' NO tiene solucin.');
         expl = str2mat('   Proporcione coeficientes de x y y diferentes de 0 en ambas ecuaciones.',...
              ' ',...
             ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
         
      else
            %Proceso de solucin mediante EGsP
            if A(1,2) ~= 0 & A(2,2) ~= 0,
               %Se considera el caso de un sistema compatible dependiente
               if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
                  set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                  acetato(' OBSERVACION: El sistema',['    (' sprintf('%.9g',A(1,1)) ')x + (' sprintf('%.9g',A(1,2)) ')y = ' sprintf('%.9g',b(1))],['    (' sprintf('%.9g',A(2,1)) ')x + (' sprintf('%.9g',A(2,2)) ')y = ' sprintf('%.9g',b(2))],' es dependiente y tiene una infinidad de soluciones.');
                  expl = str2mat(['   La segunda ecuacin se obtiene al multiplicar por ' sprintf('%.5g',(A(2,2)/A(1,2)))],...
                       '  la primer ecuacin.',...
                       ' ',...
                      ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
                  set(NIPtexto,'String',expl);
                  
               %Se considera el caso de un sistema incompatible   
               elseif (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) ~= (b(2)/A(2,2)),
                  set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                  acetato(' OBSERVACION: El sistema',['    (' sprintf('%.9g',A(1,1)) ')x + (' sprintf('%.9g',A(1,2)) ')y = ' sprintf('%.9g',b(1))],['    (' sprintf('%.9g',A(2,1)) ')x + (' sprintf('%.9g',A(2,2)) ')y = ' sprintf('%.9g',b(2))],' NO tiene solucin.');
                  expl = str2mat('   Las ecuaciones forman un sistema incompatible.',...
                       ' ',...
                       ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']); 
                  set(NIPtexto,'String',expl);  
                  
               %El caso del sistema concurrente   
               else
                  %Se simula el guardar los coeficientes del sistema en representacin interna
                  %de una computadora que trabaja en base 10.
                  a11 = guardar(A(1,1),t); a12 = guardar(A(1,2),t); b1 = guardar(b(1),t);
                  a21 = guardar(A(2,1),t); a22 = guardar(A(2,2),t); b2 = guardar(b(2),t);
                    
                  %Solucin exacta
                  s = A\b;
                          
                  if abs(valornum(a11)) == 0,
                     set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                     acetato(' OBSERVACION:',['La matriz  A = ' sprintf('%.7g',A(1,1)) '  ' sprintf('%.7g',A(1,2))],['                         ' sprintf('%.7g',A(2,1)) '  ' sprintf('%.7g',A(2,2))],'es singular.');
                     expl = str2mat( ...
                         ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
                     set(NIPtexto,'String',expl);
                  else
                     %mltiplo     
                     m = op_flot(a21,a11,'/');
                     %Obtencin de la matriz triangular superior
                     a21 = op_flot(a21,op_flot(m,a11,'*'),'-');  % <- debe ser 0
                     a22 = op_flot(a22,op_flot(m,a12,'*'),'-');
                     b2 = op_flot(b2,op_flot(m,b1,'*'),'-');
                     if abs(valornum(a22)) == 0,
                        set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                        acetato(' OBSERVACION:','Al efectuar E G s P se ha obtenido un sistema','no sobredeterminado:',['  ' notacion(a11) '   ' notacion(a12) '   ' notacion(b1)],['  ' notacion(a21) '   ' notacion(a22) '   ' notacion(b2)],'',['La matriz  A = ' sprintf('%.7g',A(1,1)) '  ' sprintf('%.7g',A(1,2))],['                      ' sprintf('%.7g',A(2,1)) '  ' sprintf('%.7g',A(2,2))],'es cercana a ser singular.');
                        expl = str2mat( ...
                            ['   Al trabajar con precisin t = ' num2str(t) ' dgitos La matriz A  es singular.'],...
                             ' ',...
                            ['   La solucin exacta del sistema es (x,y) = ('  sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                        set(NIPtexto,'String',expl);
                     else
                        %Solucin del sistema (sustitucin hacia atrs)
                        yG = op_flot(b2,a22,'/');
                        xG = op_flot(op_flot(b1,op_flot(a12,yG,'*'),'-'),a11,'/');
                                   
                        %Clculo de residuales
                        r1 = A(1,1)*(valornum(xG)) + A(1,2)*(valornum(yG))- b(1);
                        r2 = A(2,1)*(valornum(xG)) + A(2,2)*(valornum(yG))- b(2);
                        r1 = guardar(r1,t);
                        r2 = guardar(r2,t);
                        set(ejes,'Visible','on','Position',[.05 .45 .7 .52]);
                        acetato('La solucin del sistema mediante E G s P es',['    x_G = ' notacion(xG)],['    y_G = ' notacion(yG)],'',['    r1 = ' sprintf('%.7g',A(1,1)) 'x_G + ' sprintf('%.7g',A(1,2)) 'y_G - ' sprintf('%.7g',b(1))],['       = ' notacion(r1)],'',['    r2 = ' sprintf('%.7g',A(2,1)) 'x_G + ' sprintf('%.7g',A(2,2)) 'y_G - ' sprintf('%.7g',b(2))],['       = ' notacion(r2)]); 
                        expl = str2mat('   Se muestra la solucin numrica as como los residuales r1 y r2 en notacin',...
                            ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                             ' ',...
                            ['   La solucin exacta del sistema es (x,y) = ('  sprintf('%.7g',s(1)) ',' sprintf('%.7g',s(2)) ')']);
                        set(NIPtexto,'String',expl);
                     end %if abs(valornum(a22))...
                  end %if abs(valornum(a11))...
               end %if (A(1,1)/A(1,2)) == (A(2,1)/A(2,2)) & (b(1)/A(1,2)) == (b(2)/A(2,2)),
            end %if A(1,2) ~= 0 & A(2,2) ~= 0,
      end %if isequal(A,zeros(2,2)) & isequal(b,zeros(2,1)), 
   else
      errordlg('Falta introducir algn o algunos coeficientes','E R R O R'); 
   end  %if ~isempty...

elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' REGLA DE CRAMER',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' La Regla de Cramer calcula la solucin de un sistema de ecuaciones',...
      'lineales en trminos de cocientes de determinantes. Se resuelve',...
      'mediante este mtodo el sistema',...
      '                  0.373{\it x} + 0.296{\it y} = 0.521  (1)',...
      '                  0.326{\it x} + 0.260{\it y} = 0.456  (2)',...
      'y se mide el valor de r1 y r2.',...
      ' Los residuales r1 y r2 son los valores resultantes de evaluar',...
      'la solucin numrica (x_{c},y_{c}) en las ecuaciones (1) y (2)',...
      'respectivamente, previamente igualadas a cero. ',...
      ' ',...
      ' {\it Atencin:} La Regla de Cramer no es conveniente como algoritmo',...
      'numrico para resolver sistemas grandes debido a la gran cantidad',...
      'de tiempo que requerira para calcular todos los determinantes.',...
      ' ',...
      ' Como ejercicio, usted puede escribir sus propios coeficientes en',...
      'la ventana anterior situando el cursor en los campos editables y',...
      'borrando los valores actuales.','',...
      'Programa fuente: cramer.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');

end %if strcmp(entrada,...)
