function cercanos(entrada);
%CERCANOS crea la ventana que presenta el ejemplo de la sustraccin
%a - b con nmeros muy cercanos entre s
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' SUSTRACCION CON NUMEROS MUY CERCANOS ENTRE SI',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .59]);
   
   %Comentarios de inicio
   indica = str2mat('   Tenemos los nmeros reales a y b arriba escritos. Note que son valores',...
         '  muy cercanos entre s.',...
         ' ',...
         '   Presione el botn ''a - b'' para efectuar esta operacin.',...
         ' ',...
         '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
         '  longitud de mantisa. Enseguida vuelva a utilizar el botn.');
         
          
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .34],...
             'BackgroundColor',[0 .8 0]);
      
   %El campo de explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .25],...
                        'Callback','cercanos(''eval'');',...
                        'String',indica);
                     
   %Los campos editables para que el usuario proporcione sus propios nmeros.
   %Inicialmente hay valores dados, los que constituyen el ejemplo.       
   dato1 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.15 .31 .18 .05],'String','63.221473',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');
   dato2 = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.48 .31 .18 .05],'String','63.221486',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');        
                  
   %Los rtulos 'a =' y 'b =' 
   uicontrol('Style','text','Units','normalized',...
             'Position',[.12 .31 .03 .05],'String','a =',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.45 .31 .03 .05],'String','b =',...
             'Backgroundcolor',[0 .8 0]);
           
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Cancelacin','Callback','cancenum;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn 'a - b'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .8 .16 .06],...
             'String','a - b',...
             'Callback','cercanos(''ejecuta'');',...
             'UserData','a_b');
   
   %Men 'precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .7 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .71 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .63 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','cercanos(''ejecuta'');',...
                    'Value',7);
    
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','cercanos(''info'');');
    
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Se guardan los campos editables, el cuadro de explicaciones y el men 'precisin'
   %pues se requerirn en la siguiente parte del programa.
   cambios = [dato1 dato2 NIPtexto prec];
   set(gcf,'UserData',cambios);
   
elseif strcmp(entrada,'ejecuta'), 
   
   %Se traen los objetos grficos salvados anteriormente
   cambios = get(gcf,'UserData');
   dato1 = cambios(1);
   dato2 = cambios(2);
   NIPtexto = cambios(3);
   prec = cambios(4);
   resta = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Obtencin de los nmeros introducidos por el usuario   
   if ~isempty(get(dato1,'String')) & ~isempty(get(dato2,'String')),   
      minuendo = eval(get(dato1,'String'));
      sustraendo = eval(get(dato2,'String'));
      
      if minuendo == 0 & sustraendo == 0,
         acetato('  OBSERVACION:','  a = b = 0');
         expl = str2mat(' ',...
                        '   Para cumplir con el propsito de este ejercicio proporcione',...
                        '  nmeros a,b distintos de 0 y de modo que a y b sean valores muy',...
                        '  cercanos entre s.');
         set(NIPtexto,'String',expl);
      else
         %La resta exacta de los nmeros de este ejemplo
         restaExacta = minuendo-sustraendo;
          
         %Se simula el guardar los nmeros reales en representacin interna
         %de una computadora que trabaja en base 10
         a = guardar(minuendo,t);  
         b = guardar(sustraendo,t);  
         
         %resta a-b
         restaNumerica = op_flot(a,b,'-');
         
         %error relativo de a-b
         er = abs(restaExacta - valornum(restaNumerica))/abs(restaExacta); 
         %si eps <= e.r. < 1, el e.r. se escribe en notacin de punto flotante
         %decimal con precisin 2
         if er == 1, er = num2str(1);
         elseif er < eps, er = num2str(0);
         else er = guardar(er,2); er = notacion(er);
         end   
         
         %Activacin del botn 'a - b'
         if strcmp(resta,'a_b'),
            if minuendo ~=0 & sustraendo == 0,
               acetato('  OBSERVACION:',' b = 0 es el elemento neutro aditivo de los nmeros reales','',['      a = ' notacion(a)],'      b = 0',['     a + b = ' notacion(a)]);
               expl = str2mat('',...
                  '   Proporcione un nmero b distinto de 0 y de modo que b sea un valor',...
                  '  muy cercano al valor a.',...
                  ' ',...
                 ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
              set(NIPtexto,'String',expl);
            elseif minuendo == 0 & sustraendo ~= 0,
              acetato('  OBSERVACION:',' a = 0 es el elemento neutro aditivo de los nmeros reales','','      a = 0',['      b = ' notacion(b)],['     a + b = ' notacion(b)]);
              expl = str2mat('',...
                 '   Proporcione un nmero a distinto de 0 y de modo que a sea un valor',...
                 '  muy cercano al valor b.',...
                 '',...
                ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
              set(NIPtexto,'String',expl);
            elseif minuendo ~= 0 & minuendo ~= 0,
              acetato('','',['      a = ' notacion(a)],['      b = ' notacion(b)],['     a - b = ' notacion(restaNumerica)],'',['      La resta exacta es: ' sprintf('%.10g',restaExacta)],['      e. r.: ' er]);
              expl = str2mat('   Se muestran los nmeros a,b as como la diferencia   a - b  en notacin',...
                       ['  de punto flotante decimal con ' num2str(t) ' dgitos de precisin.'],...
                       ' ',...
                       '   Compare la resta exacta con la resta numrica.',...
                       ' ',...
                       '   e.r. es el error relativo de a - b ');
              set(NIPtexto,'String',expl);
            end %if minuendo ~= 0 & sustraendo == 0        
         end %if strcmp(resta,...)    
      end %if minuendo == 0 & sustraendo == 0  
   else   
      errordlg('Introduzca sus nmeros antes de usar los botones y/o el men ''Precisin''','E R R O R');
   end %if ~isempty(get(dato1,'String')) & ...
   
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' SUSTRACCION CON NUMEROS MUY CERCANOS ENTRE SI',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' Si dos nmeros {\it a,b} de punto flotante son del mismo orden y',...
      'coinciden en sus primeras {\it s} cifras, es decir si',...
      '              {\it a} = (.{\it a_{1}a_{2}...a_{s}a_{s+1}...a_{t}}) \times \beta^{\it e}',...
      '              {\it b} = (.{\it a_{1}a_{2}...a_{s}b_{s+1}...b_{t}}) \times \beta^{\it e}',...
      'entonces al restarlos tenemos',...
      '              {\it c} = {\it fl(a-b)} = (.00...0\it{c_{s+1}...c_{t}}) \times \beta^{\it e}.',...
      ' Esto significa que al hacer la resta de {\it a} y {\it b} se pierden las cifras',...
      'ms significativas (las que aseguran la buena aproximacin del',...
      'nmero) y el resultado {\it c} no necesariamente tiene que ser una',...
      'buena aproximacin.',...
      ' Para ejemplificar el fenmeno de cancelacin numrica se efecta',...
      'la resta {\it a-b} con {\it a} = 63.221473, {\it b} = 63.221486 ',...
      'utilizando diferentes valores de precisin.',' ',...
      ' Como ejercicio, usted puede escribir sus propios nmeros en la',...
      'ventana anterior situando el cursor en los campos editables y',...
      'borrando los valores actuales.','',...
      'Programa fuente: cercanos.m');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
   
end %if strcmp(entrada,...)