function campo(entrada);
%CAMPO crea la ventana que presenta el tema de las propiedades de los n\'umeros reales.
%
% Funcin creada por Fernando Saldaa Jimnez.
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' OPERACIONES BASICAS CON LOS NUMEROS DE PUNTO FLOTANTE',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   %Propsito del tema
   indica = str2mat(' ',...
           '   Propsito del tema: ',...
           '',...
           '  Mostrar que en Aritmtica de Punto Flotante no se cumplen',...
           '  de manera general algunas propiedades de los nmeros reales.',...
           '','','','','','',...
           '   Instrucciones: Oprima alguno de los botones a la derecha',...
           '  segn la propiedad que desee estudiar.');
   
   %El marco del propsito e instrucciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.05 .25 .6 .5],...
             'BackgroundColor',[1 1 1]);
   
   %El campo del propsito e instrucciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',15,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.07 .27 .56 .46],...
                        'String',indica);
   
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del Taller    
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
    
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.7 .03 .27 .94],...
             'BackgroundColor',[0 .8 0]);
    
   %El cuadro 'Asociatividad de la suma'
   uicontrol('Style','frame','Units','normalized', ...
             'Position',[.71 .71 .25 .24],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.73 .88 .21 .06],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String',str2mat('Asociatividad','de la suma:'));
   %Botn 'Suma de 3 nmeros'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .8 .23 .06],...
             'String','de 3 nmeros',...
             'Callback','sum3num(''iniciar'');');
   %Botn 'Suma de 1200 1's'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.72 .72 .23 .06],...
             'String','de 1200 1''s',...
             'Callback','suma1s(''iniciar'');');
   
   %Botn 'Elemento neutro aditivo'
   uicontrol('Style','pushbutton','Units','normalized', ...
             'Position',[.72 .63 .23 .06],...
             'String','Elemento neutro aditivo',...
             'Callback','neutroad(''iniciar'');');
        
   %El cuadro 'Asociatividad del proucto'
   uicontrol('Style','frame','Units','normalized', ...
             'Position',[.71 .49 .25 .12],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.73 .57 .21 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String',str2mat('Asociatividad del'));
   %Botn 'Producto de 3 nmeros'
   uicontrol('Style','pushbutton','Units','normalized', ...
             'Position',[.72 .5 .23 .06],...
             'String','producto de 3 nmeros',...
             'Callback','prod3num(''iniciar'');');
        
   %Botn 'Cerradura del producto'
   uicontrol('Style','pushbutton','Units','normalized', ...
             'Position',[.72 .41 .23 .06],...
             'String','Cerradura del producto',...
             'Callback','crradura(''iniciar'');');
   
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.72 .07 .23 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
          
end %if strcmp(entrada,...)