function taller(entrada);
%'TALLER' CREA LA VENTANA DE PRESENTACION.
%Esta ventana presenta las opciones iniciales con que cuenta
%el sistema.
%
% Funcin creada por Fernando saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

%Se carga el archivo taller.mat que contiene
%informacin sobre el grfico de la funcin arcotangente.

load taller

%Con lo siguiente basta teclear en Matlab  >>taller y no  >>taller('inicia')
if nargin<1,  
   entrada = 'inicia'; 
end

if strcmp(entrada,'inicia'),
 close all; clc  
 % Se genera la ventana de Presentacin del Taller.
 h = figure('Units','normalized','Name',' B I E N V E N I D A','Color',[1 1 0.9],...
    'Menubar','none','Position',[.14 .18 .7 .7],'NumberTitle','off','Visible','on');
  
 %Las lneas identificadas como h2 crean el grfico de la funcin arcotangente as como
 %la visualizacin del mtodo de Newton para encontrar el cero de una funcin. Esto
 %se hace sobre los ejes identificados como h1. Se toma informacin de taller.mat
 h1 = axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .6]);
 h2 = line('Parent',h1, ...
   	'Color',[1 0 1], ...
	   'XData',mat2, ...
	   'YData',mat3);
 h2 = line('Parent',h1, ...
    	'Color',[1 0 0], ...
 	   'XData',mat4, ...
 	   'YData',mat5);
 h2 = line('Parent',h1, ...
   	'Color',[1 0 0], ...
	   'LineStyle','none', ...
	   'Marker','o', ...
	   'XData',mat6, ...
	   'YData',mat7);
 h2 = line('Parent',h1, ...
   	'Color',[0 0 1], ...
	   'XData',[-5 5], ...
	   'YData',[0 0]);
 h2 = line('Parent',h1, ...
    	'Color',[0 0 1], ... 
 	   'XData',[0 0], ...
   	'YData',[-2 2]);
  
 %Men 'VENTANA'
   vent = uimenu(h,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
 
 %Se escriben las instrucciones de la miniventana.
 inst = str2mat('   Para conocer ms acerca del Taller e interactuar con l utilice los botones',...
     '  situados en la parte derecha:',...
     '  El botn ''Presentacin'' le proporciona informacin general de este sistema.',...
     '  El botn ''Temas'' le muestra los tpicos que conforman el Taller.',...
     '  El botn ''Referencias'' presenta una lista de referencias bibliogrficas.',...
     ' ',...
     '  El botn ''Salir'' permite terminar con la sesin del Taller y regresar a Matlab.');
  
 %El marco del cuadro de comentarios y explicaciones
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.03 .03 .74 .34],...
           'BackgroundColor',[0 .8 0]);
   
 %El rtulo fijo
 uicontrol('Style','text','Units','normalized',...
           'Position',[.05 .3 .7 .05],...
           'BackgroundColor',[0 .6 0],...
           'ForegroundColor',[1 1 1],...
           'String','I N S T R U C C I O N E S :');
   
 %El campo editable de explicaciones
 NIPtexto = uicontrol('Style','text','Units','normalized',...
                      'HorizontalAlignment','left',...
                      'Max',10,...
                      'BackgroundColor',[1 1 1],...
                      'Position',[.05 .05 .7 .25],...
                      'String',inst);
                   
 %La consola de botones y menus de control
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.78 .03 .2 .94],...
           'BackgroundColor',[0 .8 0]);
 
 %Botn 'Presentacin'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .86 .16 .06],...
           'String','Presentacin',... 
           'Call','taller(''presenta'');');
   
 %botn 'Temas'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .78 .16 .06],...
           'String','T e m a s',...
           'Callback','temas(''iniciar'');');
   
 %botn 'Referencias'
 uicontrol('Style','pushbutton','Units','normalized', ...
           'Position',[.8 .7 .16 .06],...
           'String','Referencias',... 
           'Call','taller(''biblio'');');
  
 %botn 'Salir'. De este modo se regresa a Matlab
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .07 .16 .06],...
           'String','S a l i r',...
           'Callback','close(gcf)');

 %Se da el mensaje de Bienvenida al Taller.
 pause(.5)
 text(-3,1.5,'B I E N V E N I D O S','fontsize',[20],...
    'fontname','bold','color','b');pause(1)
 text(-0.5,0.8,'A L','fontsize',[20],'fontname','bold');pause(.4)
 text(-1.5,0,'T A L L E R','fontsize',[20],'fontname','bold');pause(.4)
 text(-0.5,-0.8,'D E','fontsize',[20],'fontname','bold');pause(.4)
 text(-4.5,-1.5,'A N A L I S I S  N U M E R I C O','fontsize',[20],...
    'fontname','bold');
 
elseif strcmp(entrada,'regresa'),
 load taller
 close
   % Se genera la ventana de Presentacin del Taller.
 h = figure('Units','normalized','Name',' B I E N V E N I D A','Color',[1 1 0.9],...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
  
 %Las lneas identificadas como h2 crean el grfico de la funcin arcotangente as como
 %la visualizacin del mtodo de Newton para encontrar el cero de una funcin. Esto
 %se hace sobre los ejes identificados como h1. Se toma informacin de taller.mat
 h1 = axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .6]);
 h2 = line('Parent',h1, ...
   	'Color',[1 0 1], ...
	   'XData',mat2, ...
	   'YData',mat3);
 h2 = line('Parent',h1, ...
    	'Color',[1 0 0], ...
 	   'XData',mat4, ...
 	   'YData',mat5);
 h2 = line('Parent',h1, ...
   	'Color',[1 0 0], ...
	   'LineStyle','none', ...
	   'Marker','o', ...
	   'XData',mat6, ...
	   'YData',mat7);
 h2 = line('Parent',h1, ...
   	'Color',[0 0 1], ...
	   'XData',[-5 5], ...
	   'YData',[0 0]);
 h2 = line('Parent',h1, ...
    	'Color',[0 0 1], ... 
 	   'XData',[0 0], ...
   	'YData',[-2 2]);
  
 %Men 'VENTANA'
   vent = uimenu(h,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
 
 %Se escriben las instrucciones de la miniventana.
 inst = str2mat('   Para conocer ms acerca del Taller e interactuar con l utilice los botones',...
     '  situados en la parte derecha:',...
     '  El botn ''Presentacin'' le proporciona informacin general de este sistema.',...
     '  El botn ''Temas'' le muestra los tpicos que conforman el Taller.',...
     '  El botn ''Referencias'' presenta una lista de referencias bibliogrficas.',...
     ' ',...
     '  El botn ''Salir'' permite terminar con la sesin del Taller y regresar a Matlab.');
    
 %El marco del cuadro de comentarios y explicaciones
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.03 .03 .74 .34],...
           'BackgroundColor',[0 .8 0]);
   
 %El rtulo fijo
 uicontrol('Style','text','Units','normalized',...
           'Position',[.05 .3 .7 .05],...
           'BackgroundColor',[0 .6 0],...
           'ForegroundColor',[1 1 1],...
           'String','I N S T R U C C I O N E S :');
   
 %El campo editable de explicaciones
 NIPtexto = uicontrol('Style','text','Units','normalized',...
                      'HorizontalAlignment','left',...
                      'Max',10,...
                      'BackgroundColor',[1 1 1],...
                      'Position',[.05 .05 .7 .25],...
                      'String',inst);
                   
 %La consola de botones y menus de control
 uicontrol('Style','frame','Units','normalized',...
           'Position',[.78 .03 .2 .94],...
           'BackgroundColor',[0 .8 0]);
 
 %botn 'Presentacin'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .86 .16 .06],...
           'String','Presentacin',...
           'Call','taller(''presenta'');');
   
 %botn 'Temas'
 uicontrol('Style','pushbutton','Units','normalized',...
           'Position',[.8 .78 .16 .06],...
           'String','T e m a s',...
           'Callback','temas(''iniciar'');');
   
 %botn 'Referencias'
 uicontrol('Style','pushbutton','Units','normalized', ...
           'Position',[.8 .7 .16 .06],...
           'String','Referencias',...
           'Call','taller(''biblio'');');
  
 %botn 'Salir'. De este modo se regresa a Matlab
 uicontrol('Style','push','Units','normalized',...
           'Position',[.8 .07 .16 .06],...
           'String','S a l i r',...
           'Callback','close(gcf)');

 %Se da el mensaje de Bienvenida al Taller.
 text(-3,1.5,'B I E N V E N I D O S','fontsize',[20],...
    'fontname','bold','color','b');
 text(-0.5,0.8,'A L','fontsize',[20],'fontname','bold');
 text(-1.5,0,'T A L L E R','fontsize',[20],'fontname','bold');
 text(-0.5,-0.8,'D E','fontsize',[20],'fontname','bold');
 text(-4.5,-1.5,'A N A L I S I S  N U M E R I C O','fontsize',[20],...
    'fontname','bold');

elseif strcmp(entrada,'presenta'),
   texto1 = str2mat(' ',' ',...
      '    Conceptualizacin:',...
      '    El Taller de Anlisis Numrico es un sistema computacional implementado',...
      '  en Matlab v.5.3 que muestra una simulacin de la Aritmtica de Punto',...
      '  Flotante, que es la aritmtica que toda computadora realiza al efectuar',...
      '  clculos numricos.',...
      ' ',...
      '    En el Taller las operaciones aritmticas de punto flotante se realizan',...
      '  en base 10 pues es el sistema de numeracin con el que todos estamos',...
      '  familiarizados. Se menciona este detalle pues aunque la mayora de las',...
      '  computadoras trabajan internamente en base 2, los aspectos o fenmenos',...
      '  numricos que se pretenden destacar en el Taller no son propios de una',...
      '  base en particular.',...
      ' ',' ',...
      '    Objetivo:',...
      '    El Taller de Anlisis Numrico se ofrece como material introductorio',...
      '  y complementario para los cursos de anlisis numrico o mtodos',...
      '  numricos que se imparten en las carreras de ciencias exactas',... 
      '  e ingenieras. ');
   texto2 = str2mat(' ',' ',...
      '    Descripcin General:',...
      '    El Taller es un sistema interactivo, amigable y de fcil manejo pues se ha',...
      '  diseado sobre la moderna plataforma de ventanas de interfaz, es decir,',...
      '  mediante la disposicin de una barra de mens, botones de activacin',...
      '  y una agradable presentacin de cuadros con texto que proporcionan las',...
      '  instrucciones necesarias e informacin general, el usuario es introducido',...
      '  a travs de la exposicin de ejemplos especialmente seleccionados para',...
      '  cada tema a las sorprendentes patologas numricas que tienen lugar',...
      '  cuando se efectan clculos en aritmtica de punto flotante.',...
      ' ',...
      '    Los ejemplos que se han preparado son muchos de ellos elementales,',...
      '  requieren de relativamente pocas operaciones aritmticas y se trabajan',...
      '  con pocos dgitos de precisin. Pero dichos ejemplos ilustran lo que',...
      '  sucede cuando la computadora trabaja con problemas matemticos',...
      '  grandes que involucran muchsimas operaciones aritmticas, con',...
      '  algunas cifras ms de precisin.',...
      ' ',...
      '    Adems este sistema le brinda al usuario la opcin de experimentar con',...
      '  otros ejemplos del tema en que se encuentra introduciendo l mismo los',...
      '  valores que se solicitan, lo que le permite realizar muchos ejercicios',...
      '  numricos en poco tiempo evitando la tediosa labor de hacer aritmtica',...
      '  con lpiz y papel.');
   texto3 = str2mat(' ',' ',...
      '    Antecedentes:',...
      '    Se cuenta con versiones precedentes del Taller en BASIC y FORTRAN;',...
      '  en tales sistemas el medio de interaccin entre el usuario y los programas',...
      '  es el teclado, particularmente las teclas numricas.',...
      ' ',...
      '    El propsito de implementar el Taller en Matlab es darle una nueva y mejor',...
      '  presentacin, aprovechando las enormes facilidades de este lenguaje para',...
      '  el diseo de ventanas de interfaz adems de su poderoso ambiente para la',...
      '  realizacin de cmputo numrico y graficacin.',...
      '','','',...
      '    Crditos:',...
      '    El Taller de Anlisis Numrico fue diseado por:',...
      '  Fernando Saldaa Jimnez, de la',...
      '  Escuela de Matemticas, Universidad Autnoma de Coahuila.',...
      '',...
      '    Con la asesora de los maestros:',...
      '  Dr. Jess Lpez Estrada,',...
      '    Departamento de Matemticas, Facultad de Ciencias, UNAM',...
      '  Dr. Humberto Madrid de la Vega,',...
      '    Centro de investigacin en Matemticas Aplicadas, UA de C',...
      '',...
      '                                                                30 noviembre 2000');
  explicac('Presentacin',texto1,texto2,texto3);
   
elseif strcmp(entrada,'biblio'),
   texto1 = str2mat( ...
      '  1. "Accuracy and Stability of Numerical Algorithms".',...
      '     Nicholas J. Higham.',... 
      '     Society for Industrial and Applied Mathematics, 1996.',...
      ' ',...
      '  2. "Introduction to Scientific Computing: A Matrix-Vector Approach',...
      '     Using MATLAB". Charles F. Van Loan.',...
      '     Prentice Hall, 1997.',...
      ' ',...
      '  3. "Mastering Matlab 5 -a comprehensive tutorial and reference".',...
      '     Duane Hanselman, Bruce Littlefield.',...
      '     Prentice Hall, 1998.',...
      ' ',...
      '  4. "Pitfalls in Computation, or Why a Math Book Isn''t Enough".',...
      '     George E. Forsythe.',...
      '     Amer. Math. Monthly, pags. 931-956, 1970.',...
      ' ',...
      '  5. "Numerical Methods".',...
      '     Dahlquist, G. and A. Bjrck.',...
      '     Prentice Hall, 1974.',...
      ' ',...
      '  6. "Fundamentals of Numerical Computing".',...
      '     R. Allen, S. Pruess, L. Shampine.',...
      '     Publicaciones del Depto. de Matemticas de la FC de la UNAM, 1986.',...
      ' ',...
      '  7. "The Engineering of Numerical Software".',...
      '     Web Miller.',...
      '     Prentice Hall in Computational Mathematics, 1984.');
   texto2 = str2mat( ...
      '  8. "IEEE Standard for Binary Floating-Point Arithmetic,',...
      '     ANSI/IEEE 754-1985".',...
      '     Institute of Electrical and Electronic Engineers, 1985.',...
      ' ',...
      '  9. "Cancellation and Rounding Errors".',...
      '     J. Barkley Rosser and J. Michael Yohe.',...
      '     Mathematics Research Center, University of Wisconsin, 1976.',...
      ' ',...
      ' 10. "Roundings in Floating-Point Arithmetic".',...
      '     J. Michael Yohe.',...
      '     IEEE Transactions on Computers, vol. C-22, no. 6, 1973.',...
      ' ',...
      ' 11. "What is a Satisfactory Quadratic Equation Solver?".',...
      '     George E. Forsythe, en ''Constructive Aspects of the Fundamental',...
      '     Theorem of Algebra'',pags. 53-61, 1969.',...
      ' ',...
      ' 12. "Solving Linear Algebraic Equations can be Interesting".',...
      '     George E. Forsythe.',...
      '     Bull. Amer. Math. Soc., 1953.',...
      ' ',...
      ' 13. "Singularity and Near Singularity in Numerical Analysis".',...
      '     George E. Forsythe.',...
      '     Amer. Math. Monthly 65, 1958.',...
      ' ',...
      ' 14. "Generation of Errors In Digital Computation".',...
      '     Alston S. HouseHolder.',...
      '     Bull. Amer. Math. Soc., 1954.');
   texto3 = str2mat( ...
      ' 15. "What Every Computer Scientist Should Know About',...
      '     Floating-Point Arithmetic". David Golberg.',...
      '     ACM Computing Surveys, vol. 23, no. 1, 1991.',...
      ' ',...
      ' 16. "Miscalculating Area and Angles of a Needle-like Triangle".',...
      '     William Kahan.',...
      '     Lecture Notes for Introductory Numerical Analysis Classes, 1997.',...
      ' ',...
      ' 17. "Best ''ordering'' for Floating-Point Addition".',...
      '     T. G. Robertazzi, S. C. Schwartz.',...
      '     ACM Transactions on Mathematical Software, vol. 14, no. 1, 1988.',...
      ' ',...
      ' 18. "How Reliable are Results of Computers?".',...
      '     S. M. Rump.',...
      '     Jahrbuch berblicke Mathematik, pags. 163-168, 1983.',...
      ' ',...
      ' 19. "Anlisis Numrico (la Nostalgia del Contnuo)".',...
      '     J. Guerrero, I. Snchez.',...
      '     Revista EUREKA, pags. 30-44, marzo 1998.',...
      ' ',...
      ' 20. "El Almacenaje de Informacin Numrica',...
      '     en una Computadora Digital". J. Guerrero.',...
      '     Revista EUREKA, pags. 45-51, marzo de 1998.',...
      ' ',...
      ' 21. "Cramer''s Rule on 2-by-2 Systems".',...
      '     Cleve Moler.',...
      '     Unpublished Working Note. Albuquerque, New Mexico.');
   explicac('Referencias Bibliogrficas',texto1,texto2,texto3);   
end  %if strcmp ... 