function x = valornum(v)
%VALORNUM emite el valor numrico de un nmero de punto flotante.
%
% De entrada:
%  v es un vector de longitud t+1 que representa un nmero de 
%  punto flotante; en las componentes v(1) a v(t) se guarda la 
%  mantisa y en v(t+1) el exponente.  
% 
% Resultado:
%  x es el valor numrico de v.
%
% Funcin implementada por Fernando Saldaa Jimnez, basada en convert.m
% (Introduction to Scientific Computing: A Matrix-Vector Approach 
% Charles F. Van Loan)
% Ultima fecha de modificacin: 30 noviembre 2000

t = length(v)-1;
                     
if v == zeros(1,t+1)
         x = 0;
elseif abs(v) == inf
         x = v;
else
         s = abs(v(1))*10^(t-1);
         for k = 2:t
             s = s + (10^(t-k))*v(k);
         end 
         
         x = sign(v(1))*s*10^(v(t+1)-t);
      end 
      format long g;
   