function triangul(entrada);
%TRIANGUL calcula el rea de un tringulo en forma de aguja.
%Se comparan la frmula de Hern con la frmula de Kahan.
%
% Funcin creada por Fernando Saldaa jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' AREA DE TRIANGULOS EN FORMA DE AGUJA',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .6]);
      
   %Acetato de la presentacin del problema
   x = [.05 .65 .64 .05];
   y = [.15 .15 .22 .15];
   fill(x,y,'m'); axis([0 1 0 1]);
   text(0.03,0.9,'Calcular el rea del tringulo','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
   text(0.03,0.8,'cuyas medidas de sus lados son','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
   text(0.22,0.1,'a = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
   text(0.17,0.28,'b = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
   text(0.65,0.21,'c = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
   set(gca,'XTick',[],'Ytick',[],'Box','on');
          
   %Los campos editables para que el usuario proporcione sus propias medidas de los lados.
   %Inicialmente hay valores dados, los que constituyen el ejemplo.             
   lado_a = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.25 .41 .18 .05],'String','100000',...
                     'HorizontalAlignment','left');
   lado_b = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.22 .52 .18 .05],'String','99999.99979',...
                     'HorizontalAlignment','left');        
   lado_c = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.55 .48 .18 .05],'String','0.00029',...
                     'HorizontalAlignment','left');
              
             
   %Comentarios de inicio
   indica = str2mat(' ',...
     '   Oprima alguno de los botones de la parte derecha superior segn el mtodo',...
     '  que elija para encontrar el rea del tringulo arriba mostrado.',...
     ' ',...
     '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
     '  longitud de mantisa. Enseguida vuelva a utilizar los botones.');
      
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
           'Position',[.03 .03 .74 .34],...
           'BackgroundColor',[0 .8 0]);
                   
   %El campo de explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .3],...
                        'Callback','triangul(''eval'');',...
                        'String',indica);
                     
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
                  
   %Men 'REGRESAR' a mdulos anteriores del taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Cancelacin','Callback','cancenum;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
         
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
              
   %Botn 'Frmula de Hern'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.79 .86 .18 .06],...
             'String','Frmula de Hern',...
             'Callback','triangul(''ejecuta'');',...
             'UserData','Heron');
               
   %Botn 'Mtodo de Kahan'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.79 .78 .18 .06],...
             'String','Mtodo de Kahan',...
             'Callback','triangul(''ejecuta'');',...
             'UserData','Kahan');
     
   %Men 'Precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .68 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .69 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .61 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','triangul(''ejecuta'');',...
                    'Value',10);
       
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.79 .15 .18 .06],...
             'String','I n f o',...
             'Callback','triangul(''info'');');
    
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.79 .07 .18 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Guardar el cuadro de explicaciones, el men 'Precisin' y los ejes 
   cambios = [lado_a lado_b lado_c NIPtexto prec];
   set(gcf,'UserData',cambios);
      
elseif strcmp(entrada,'ejecuta'), 
    
   %Se traen los objetos grficos salvados con anterioridad  
   cambios = get(gcf,'UserData');
   lado_a = cambios(1);
   lado_b = cambios(2);
   lado_c = cambios(3);
   NIPtexto = cambios(4);
   prec = cambios(5);
   formula = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Obtencin de las medidas de los lados proporcionadas por el usuario
   if ~isempty(get(lado_a,'String')) & ~isempty(get(lado_b,'String')) & ~isempty(get(lado_c,'String')),
      a = eval(get(lado_a,'String'));
      b = eval(get(lado_b,'String'));
      c = eval(get(lado_c,'String'));
      v = [a b c];
      v = fliplr(sort(v)); %Nos aseguramos de que v(1) >= v(2) >= v(3)
      if v(1) <= 0 | v(2) <= 0 | v(3) <= 0,
         x = [.05 .65 .64 .05];
         y = [.15 .15 .22 .15];
         fill(x,y,'m'); axis([0 1 0 1]);
         text(0.03,0.9,' OBSERVACION:','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
         text(0.03,0.8,'Por lo menos un lado del tringulo tiene magnitud negativa','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
         text(0.03,0.7,'o magnitud igual a 0.','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
         text(0.03,0.5,'NO es posible calcular el rea de dicho tringulo.','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
         text(0.22,0.1,'a = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
         text(0.17,0.28,'b = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
         text(0.65,0.21,'c = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
         set(gca,'XTick',[],'Ytick',[],'Box','on');
         expl = str2mat(' ',...
               ['   Se trabaja con ' num2str(t) ' dgitos de precisin.']);
         set(NIPtexto,'String',expl);
      else 
         %Valor exacto del rea (Frmula de Kahan)
         valor = sqrt((a+(b+c))*(c-(a-b))*(c+(a-b))*(a+(b-c)))/4;
         %Activacin del botn 'Frmula de Hern'
         if strcmp(formula,'Heron'),
            a = guardar(v(1),t); b = guardar(v(2),t); c = guardar(v(3),t);
            s = op_flot(op_flot(c,op_flot(a,b,'+'),'+'),guardar(2,t),'/'); %((a+b)+c)/2
            Area = op_flot(s,op_flot(op_flot(op_flot(s,a,'-'),op_flot(s,b,'-'),'*'),op_flot(s,c,'-'),'*'),'*');
            Area = guardar(sqrt(valornum(Area)),t);
            %Acetato que presenta la solucin por frmula de Hern
            x = [.05 .65 .64 .05];
            y = [.15 .15 .22 .15];
            fill(x,y,'m'); axis([0 1 0 1]);
            text(0.03,0.9,'Aplicando la frmula de Hern','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.03,0.8,'A = [s(s-a)(s-b)(s-c)]^{1/2}, s = a+b+c/2','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.03,0.7,'se encuentra que el tringulo tiene de rea','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.03,0.6,[ notacion(Area) ' unidades cuadradas.'],'FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.22,0.1,'a = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
            text(0.17,0.28,'b = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
            text(0.65,0.21,'c = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
            set(gca,'XTick',[],'Ytick',[],'Box','on');
            expl = str2mat(' ',...
                 '   Se muestra el valor del rea del tringulo en notacin de punto flotante',...
                ['  decimal con ' num2str(t) ' dgitos de precisin.'],...
                 ' ',...
                ['   El valor exacto del rea es ' sprintf('%.11g',valor) ' unidades cuadradas.']);
            set(NIPtexto,'String',expl);    
                 
         %Activacin del botn 'Mtodo de Kahan'   
         elseif strcmp(formula,'Kahan'),
            a = guardar(v(1),t); b = guardar(v(2),t); c = guardar(v(3),t);
            Area = op_flot(op_flot(op_flot(op_flot(a,op_flot(b,c,'+'),'+'),op_flot(c,op_flot(a,b,'-'),'-'),'*'),op_flot(c,op_flot(a,b,'-'),'+'),'*'),op_flot(a,op_flot(b,c,'-'),'+'),'*');
            Area = guardar(sqrt(valornum(Area))/4,t);
            %Acetato que presenta la solucin por mtodo de Kahan
            x = [.05 .65 .64 .05];
            y = [.15 .15 .22 .15];
            fill(x,y,'m'); axis([0 1 0 1]);
            text(0.03,0.9,'Aplicando el mtodo de Kahan','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.03,0.8,'A = [(a+(b+c))(c-(a-b))(c+(a-b))(a+(b-c))]^{1/2} /4','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.03,0.7,'se encuentra que el tringulo tiene de rea','FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.03,0.6,[ notacion(Area) ' unidades cuadradas.'],'FontName','8x13','Fontsize',11,'color',[0 0 .7]);
            text(0.22,0.1,'a = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
            text(0.17,0.28,'b = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
            text(0.65,0.21,'c = ','FontName','8x13','Fontsize',12,'color',[0 0 .7]);
            set(gca,'XTick',[],'Ytick',[],'Box','on');
            expl = str2mat(' ',...
                 '   Se muestra el valor del rea del tringulo en notacin de punto flotante',...
                ['  decimal con ' num2str(t) ' dgitos de precisin.'],...
                 ' ',...
                ['   El valor exacto del rea es ' sprintf('%.11g',valor) ' unidades cuadradas.']);
            set(NIPtexto,'String',expl);    
         end %if strcmp(formula,...) 
      end %if v(1) <= 0 ...
   else
      errordlg('Introduzca sus nmeros antes de usar los botones y/o el men ''Precisin''','E R R O R');
   end %if ~isempty(get(lado_a,'String')) ...   
   
elseif strcmp(entrada,'info'),
   figNumber = figure('Units','normalized','Name',' AREA DE TRIANGULOS EN FORMA DE AGUJA',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' Dadas las medidas de los lados {\it a,b,c} de un tringulo es posible',...
      'determinar su rea aplicando la frmula de Hern:',...
      '       A = [{\it s}({\it s-a})({\it s-b})({\it s-c})]^{1/2},   donde {\it s} = ({\it a+b+c})/2 ',...
      'pero si se tiene un tringulo en forma de aguja, es decir un tringulo',...
      'cuyos lados {\it a,b,c} son tales que',...
      '                                      {\it a} \approx {\it b + c}' ,...
      'al trabajar en aritmtica de precisin finita se tendr que {\it s} \approx {\it a}',...
      'lo que propiciar la ocurrencia de cancelacin numrica en el',...
      'trmino ({\it s-a}) de la frmula de Hern.',... 
      ' Una alternativa para superar esta dificultad consiste en ordenar',...
      'los lados del tringulo de modo que {\it a} \geq {\it b} \geq {\it c} y luego calcular',...
      'el rea mediante el mtodo de Kahan:',...
      '       A = [({\it a+}({\it b+c}))({\it c-}({\it a-b}))({\it c+}({\it a-b}))({\it a+}({\it b-c}))]^{1/2} / 4',...
      ' ',...
      ' Como ejercicio, usted puede escribir sus propios valores en la',...
      'ventana anterior situando el cursor en los campos editables y',...
      'borrando los valores actuales.',' ',...
      'Programa fuente: triangul.m');
   
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');

end %if strcmp(entrada,...)