function temas(entrada)
% TEMAS crea la ventana que muestra los temas del taller
%
% funcin creada por Fernando Saldaa jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

% Mediante la siguiente orden es posible desplegar esta ventana
% sin iniciar el taller.
if nargin<1,
   entrada='iniciar';
end

if strcmp(entrada,'iniciar'),
   
close
h0 = figure('Units','normalized','Color',[1 1 0.9],'MenuBar','none','Name',...
     ' T  E  M  A  S','NumberTitle','off','Position',[.14 .18 .7 .7]);

%Men 'VENTANA'
   vent = uimenu(h0,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');

% Dibujo de la computadora. Primero el 'monitor' y enseguida el 'CPU'
uicontrol('Style','frame',...
   'Units','normalized',...
   'Position',[0.24 0.37 0.52 0.55]);
uicontrol('Style','frame',...
   'Units','normalized',...
   'Position',[0.16 0.08 0.68 0.22]);

% lista de los temas del taller
temario = uicontrol('Style','listbox', ...
          'Units','normalized',...
	       'BackgroundColor',[1 1 1],...
	       'Position',[0.27 0.4 0.46 0.49],...
          'String',str2mat(' 1. ''Mi Computadora'' ',...   
          ' 2. Operaciones bsicas en aritmtica de punto flotante',...
          ' 3. Cancelacin numrica',...
          ' 4. S u m a s',...
          ' 5. Resolucin de La ecuacin de segundo grado',...
          ' 6. Sistemas de ecuaciones lineales 2x2',...
          '    Regresar a Bienvenida ',...
          '    S a l i r               '),...
          'Callback',[ ...
            'tema = get(gco,''Value'');',...
               'if tema == 1, mimqn;',...
               'elseif tema == 2, campo;',...
               'elseif tema == 3, cancenum;',...
               'elseif tema == 4, sumas;',...
               'elseif tema == 5, ec2grado;',...
               'elseif tema == 6, sistemas;',...
               'elseif tema == 7, taller(''regresa'');',...
               'elseif tema == 8, close(gcf);',...
               'end'],...
          'Value',6);
       
       indica = str2mat(' Usando el ratn seale con el cursor el tema de su eleccin.',...
          ' ',...
          ' Enseguida haga click sobre dicho tpico para ver ejemplos',... 
          ' del mismo.');
       uicontrol('style','text','Units','normalized',...
                 'HorizontalAlignment','left',...
                 'Max',8,...
                 'BackgroundColor',[.75 .75 .75],...
                 'Position',[.24 .11 .56 .16],...
                 'String',indica);

end   %if strcmp...
