 function c = notacion(v)
 %NOTACION presenta un nmero previamente guardado, en notacin
 %de punto flotante decimal.
 % De entrada:
 %    v es un vector que guarda un nmero en punto flotante
 %    de t-dgitos.
 %                                         
 % Resultado:                          
 %    c es una cadena de caracteres que presenta en notacin
 %    de punto flotante el valor numrico de v.
 % Funcin implementada por Fernando Saldaa Jimnez, basada en pretty.m
 % (Introduction to Scientific Computing: A Matrix-Vector Approach 
 % Charles F. Van Loan)
 % Ultima fecha de modificacin: 30 noviembre 2000
               
 % Se convierte a caracteres la mantisa       
    
  t = length(v)-1;
                   
    if v == inf
       c = 'inf';
    elseif v==-inf
       c = '-inf';
    else
       m = ['(' '.' num2str(abs(v(1)))];
         for k = 2:t
             m(k+2) = num2str(v(k));
         end   
         if  v(1) < 0
             m = ['-' m];
         end    
                   
 % Se convierte a caracteres el exponente
       e = num2str(v(t+1));
       c = [m ')x10^{' e '}']; 
    end 
   