function crradura(entrada);
%CRRADURA ilustra el fenmeno de desbordamiento por exceso del exponente (overflow)
%
% Funcin creada por Fernando Saldaa Jimnez
% Ultima fecha de modificacin: 30 noviembre 2000

if nargin<1, entrada='iniciar'; end;

if strcmp(entrada,'iniciar'),
   close
   figNumber = figure('Units','normalized','Name',' CERRADURA DEL PRODUCTO',...
    'Position',[.14 .18 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.05 .38 .7 .59]);
   
   %Comentarios de inicio
   indica = str2mat('   Oprima el botn ''a x b'' para multiplicar los nmeros arriba escritos',...
         '  y verificar la propiedad de cerradura del producto.',...
         ' ',...
         '   Si desea modificar el valor de t abra el men  ''Precisin''  y elija una nueva',...
         '  longitud de mantisa. Enseguida vuelva a utilizar el botn.');
         
          
   %El marco del cuadro de comentarios y explicaciones
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.03 .03 .74 .34],...
             'BackgroundColor',[0 .8 0]);
      
   %El campo de explicaciones
   NIPtexto = uicontrol('Style','text','Units','normalized',...
                        'HorizontalAlignment','left',...
                        'Max',10,...
                        'BackgroundColor',[1 1 1],...
                        'Position',[.05 .05 .7 .25],...
                        'Callback','crradura(''eval'');',...
                        'String',indica);
                     
   %Los campos editables para que el usuario proporcione sus propios nmeros.
   %Inicialmente hay valores dados, los que constituyen el ejemplo.       
   a_real = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.15 .31 .18 .05],'String','2*10^(200)',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');
   b_real = uicontrol('Style','edit','Units','normalized',...
                     'Position',[.48 .31 .18 .05],'String','3*10^(150)',...
                     'Backgroundcolor',[1 1 1],...
                     'HorizontalAlignment','left');        
                  
   %Los rtulos 'a =' y 'b =' 
   uicontrol('Style','text','Units','normalized',...
             'Position',[.12 .31 .03 .05],'String','a =',...
             'Backgroundcolor',[0 .8 0]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.45 .31 .03 .05],'String','b =',...
             'Backgroundcolor',[0 .8 0]);
           
   %Men 'VENTANA'
   vent = uimenu(figNumber,'Label','VENTANA');
   uimenu(vent,'Label','Imprimir','Callback','print');
   uimenu(vent,'Label','Cerrar','Callback','close(gcf)');
   
   %Men 'REGRESAR' a mdulos anteriores del taller
   retorno = uimenu(figNumber,'Label','REGRESAR');
   uimenu(retorno,'Label','a men de Operaciones bsicas','Callback','campo;');
   uimenu(retorno,'Label','a T e m a s','Callback','temas;');
   uimenu(retorno,'Label','a Bienvenida','Callback','taller(''regresa'');');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
          
   %Botn 'a x b'
   uicontrol('Style','pushbutton','Units','normalized',...
             'Position',[.8 .8 .16 .06],...
             'String','a x b',...
             'Callback','crradura(''ejecuta'');',...
             'UserData','ab');
   
   %Men 'precisin'
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.81 .7 .14 .05],...
             'BackgroundColor',[.6 .8 1]);
   uicontrol('Style','text','Units','normalized',...
             'Position',[.82 .71 .12 .03],...
             'BackgroundColor',[.6 .8 1],...
             'ForegroundColor',[0 0 0],...
             'String','Precisin');
   prec = uicontrol('Style','popupmenu','Units','normalized',...
                    'Position',[.81 .63 .14 .07],...
                    'String',str2mat(' t = 1',' t = 2',' t = 3',...
                    ' t = 4',' t = 5',' t = 6',...
                    ' t = 7',' t = 8',' t = 9',...
                    ' t = 10',' t = 11',' t = 12',...
                    ' t = 13',' t = 14',' t = 15',' t = 16'),...
                    'Callback','crradura(''ejecuta'');',...
                    'Value',5);
    
   %Botn INFO
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .15 .16 .06],...
             'String','I n f o',...
             'Callback','crradura(''info'');');
    
   %Botn 'Salir'
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','S a l i r',...
             'Callback','close(gcf)');
   
   %Se guardan los campos editables, el cuadro de explicaciones y el men 'precisin'
   %pues se requerirn en la siguiente parte del programa.
   cambios = [a_real b_real NIPtexto prec];
   set(gcf,'UserData',cambios);
   
elseif strcmp(entrada,'ejecuta'), 
   
   %Se traen los objetos grficos salvados anteriormente
   cambios = get(gcf,'UserData');
   a_real = cambios(1);
   b_real = cambios(2);
   NIPtexto = cambios(3);
   prec = cambios(4);
   prod = get(gco,'UserData');  
   t = get(prec,'Value');
   
   %Obtencin de los nmeros introducidos por el usuario   
   if ~isempty(get(a_real,'String')) & ~isempty(get(b_real,'String')),   
      a = eval(get(a_real,'String'));
      b = eval(get(b_real,'String'));
      resultado = a*b;
      
      %Activacin del botn 'a x b'   
      if strcmp(prod,'ab'),
         if resultado == Inf,
            acetato('','',['     a = ' notacion(guardar(a,t))],'',['     b = ' notacion(guardar(b,t))],'','   a \times b = Inf');
            expl = str2mat('',...
            '   Se ha obtenido desbordamiento por exceso del exponente (overflow).',...
            '',...
            '   Si desea modificar los coeficientes y/o las potencias de 10 coloque el cursor',...
            '  en los recuadros, borre los valores actuales y escriba sus nuevos nmeros.');
            set(NIPtexto,'String',expl);
            
         elseif resultado == -Inf,
            acetato('','',['     a = ' notacion(guardar(a,t))],'',['     b = ' notacion(guardar(b,t))],'','   a \times b = -Inf');
            expl = str2mat('',...
            '   Se ha obtenido desbordamiento por exceso del exponente (overflow).',...
            '',...
            '   Si desea modificar los coeficientes y/o las potencias de 10 coloque el cursor',...
            '  en los recuadros, borre los valores actuales y escriba sus nuevos nmeros.');
         set(NIPtexto,'String',expl);
          
         elseif resultado == 0,
            acetato('','',['     a = ' notacion(guardar(a,t))],'',['     b = ' notacion(guardar(b,t))],'',['   a \times b = ' notacion(guardar(resultado,t))]);
            expl = str2mat('',...
            '   Se ha obtenido desbordamiento por defecto del exponente (underflow).',...
            '',...
            '   Si desea modificar los coeficientes y/o las potencias de 10 coloque el cursor',...
            '  en los recuadros, borre los valores actuales y escriba sus nuevos nmeros.');
            set(NIPtexto,'String',expl);
            
         else 
            acetato('','',['     a = ' notacion(guardar(a,t))],'',['     b = ' notacion(guardar(b,t))],'',['   a \times b = ' notacion(guardar(resultado,t))]);
            expl = str2mat('',...
            '   Se emite el resultado  a x b  pues est dentro del rango de valores',...
            '  representables como nmeros de punto flotante en esta mquina.',...
            '',...
            '   Pruebe escribiendo potencias de 10 de manera que la suma de ellas sea',...
            '  mayor que 308 o bien menor que -308.');
            set(NIPtexto,'String',expl);
         end %if resultado == Inf 
      end %if strcmp(prod,'ab')   
   else   
      errordlg('Introduzca sus nmeros antes de usar los botones y/o el men ''Precisin''','E R R O R');
   end %if ~isempty(get(a_real,'String')) & ...
   
elseif strcmp(entrada,'info'),   
   figNumber = figure('Units','normalized','Name',' LOS FENOMENOS DE UNDERFLOW Y OVERFLOW',...
    'Position',[.14 .2 .7 .7],'Menubar','none','NumberTitle','off','Visible','on');
   
   axes('Units','normalized','Visible','off','Position',[.01 .1 .76 .8]);
      
   infotext(' La multiplicacin es cerrada en R, esto es, si {\it a,b} \in R entonces',...
      '                              {\it a} \times {\it b} \in R',...
      'pero si se tiene el sistema {\it F} de nmeros de punto flotante y',...
      '{\it a,b} \in {\it F} cuando se efecte el producto {\it a} \times {\it b} puede ocurrir',...
      'que:',...
      ' |{\it a} \times {\it b}| < \beta^{\it m}, en cuyo caso se presenta {\it underflow}',...
      'y Matlab asigna al resultado el valor 0, o bien',...
      ' ',...
      ' |{\it a} \times {\it b}| > \beta^{\it M}, en cuyo caso se dice que hay {\it overflow}',...
      'y Matlab emite el valor especial Inf (infinito), ',...
      ' ',...
      '\beta^{\it m} \leq |{\it a} \times {\it b}| \leq \beta^{\it M}, es decir el resultado quede dentro del rango',...
      'de nmeros representables en la mquina en que se trabaja.',...
      ' ',...
      ' Como ejercicio, usted puede escribir sus propios nmeros en la',...
      'ventana anterior situando el cursor en los campos editables y',...
      'borrando los valores actuales.','',...
      'Programa fuente: crradura.m');
   
   %La consola de botones y menus de control
   uicontrol('Style','frame','Units','normalized',...
             'Position',[.78 .03 .2 .94],...
             'BackgroundColor',[0 .8 0]);
   
   %Botn cerrar
   uicontrol('Style','push','Units','normalized',...
             'Position',[.8 .07 .16 .06],...
             'String','C e r r a r',...
             'Callback','close(gcf)');
   
end %if strcmp(entrada,...)